/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.rule;

import com.walmartlabs.x12.SegmentIterator;
import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.exceptions.X12ErrorDetail;
import com.walmartlabs.x12.exceptions.X12ParserException;
import com.walmartlabs.x12.rule.X12Rule;
import java.util.HashSet;
import java.util.List;

public class UniqueDocumentX12Rule
implements X12Rule {
    private final String segmentId;
    private final int documentNumberIndex;
    private final int documentDateIndex;

    public UniqueDocumentX12Rule(String segmentId, int documentNumberIndex, int documentDateIndex) {
        this.segmentId = segmentId;
        this.documentNumberIndex = documentNumberIndex;
        this.documentDateIndex = documentDateIndex;
    }

    @Override
    public void verify(List<X12Segment> segmentList) {
        HashSet<String> documentNumbers = new HashSet<String>();
        SegmentIterator segments = new SegmentIterator(segmentList);
        while (segments.hasNext()) {
            X12Segment currentSegment = segments.next();
            if (!this.segmentId.equals(currentSegment.getIdentifier())) continue;
            String docNumber = currentSegment.getElement(this.documentNumberIndex);
            String docDate = currentSegment.getElement(this.documentDateIndex);
            if (documentNumbers.add(String.valueOf(docNumber) + "_" + docDate)) continue;
            throw new X12ParserException(new X12ErrorDetail(this.segmentId, String.valueOf(this.segmentId) + this.documentNumberIndex, "duplicate document numbers"));
        }
    }
}

