/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.standard;

import com.walmartlabs.x12.SegmentIterator;
import com.walmartlabs.x12.X12Parser;
import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.X12TransactionSet;
import com.walmartlabs.x12.exceptions.X12ParserException;
import com.walmartlabs.x12.standard.InterchangeControlEnvelope;
import com.walmartlabs.x12.standard.StandardX12Document;
import com.walmartlabs.x12.standard.X12Group;
import com.walmartlabs.x12.standard.txset.AbstractTransactionSetParserChainable;
import com.walmartlabs.x12.standard.txset.TransactionSetParser;
import com.walmartlabs.x12.standard.txset.UnhandledTransactionSet;
import com.walmartlabs.x12.util.ConversionUtil;
import com.walmartlabs.x12.util.SourceToSegmentUtil;
import com.walmartlabs.x12.util.X12ParsingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardX12Parser
implements X12Parser<StandardX12Document> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardX12Parser.class);
    public static final String ENVELOPE_HEADER_ID = "ISA";
    public static final String ENVELOPE_TRAILER_ID = "IEA";
    public static final String GROUP_HEADER_ID = "GS";
    public static final String GROUP_TRAILER_ID = "GE";
    private TransactionSetParser transactionParser;
    private UnhandledTransactionSet unhandledTransactionSet;

    @Override
    public StandardX12Document parse(String sourceData) {
        StandardX12Document x12Doc;
        block4: {
            x12Doc = null;
            try {
                if (!StringUtils.isNotEmpty((CharSequence)sourceData)) break block4;
                x12Doc = new StandardX12Document();
                List<X12Segment> segmentList = SourceToSegmentUtil.splitSourceDataIntoSegments(sourceData.trim());
                if (X12ParsingUtil.isValidEnvelope(segmentList, ENVELOPE_HEADER_ID, ENVELOPE_TRAILER_ID)) {
                    SegmentIterator segments = new SegmentIterator(segmentList);
                    this.standardParsingTemplate(segments, x12Doc);
                    break block4;
                }
                throw new X12ParserException("Invalid EDI X12 message: must be wrapped in ISA/ISE");
            }
            catch (X12ParserException e) {
                throw e;
            }
            catch (Exception e) {
                throw new X12ParserException("Invalid EDI X12 message: unexpected error", e);
            }
        }
        return x12Doc;
    }

    public boolean registerTransactionSetParser(Collection<TransactionSetParser> transactionParsers) {
        boolean isAdded = false;
        if (transactionParsers != null && !transactionParsers.isEmpty()) {
            isAdded = transactionParsers.stream().filter(Objects::nonNull).map(this::registerTransactionSetParser).reduce(true, (currAdded, wasAdded) -> currAdded != false && wasAdded != false);
        }
        return isAdded;
    }

    public boolean registerTransactionSetParser(TransactionSetParser txParser) {
        boolean isAdded = false;
        if (txParser != null) {
            if (this.transactionParser == null) {
                isAdded = true;
                this.transactionParser = txParser;
            } else if (this.transactionParser instanceof AbstractTransactionSetParserChainable) {
                return ((AbstractTransactionSetParserChainable)this.transactionParser).registerNextTransactionSetParser(txParser);
            }
        }
        return isAdded;
    }

    public void registerUnhandledTransactionSet(UnhandledTransactionSet txUnhandled) {
        this.unhandledTransactionSet = txUnhandled;
    }

    private void standardParsingTemplate(SegmentIterator segments, StandardX12Document x12Doc) {
        X12Segment currentSegment = segments.next();
        this.parseInterchangeControlHeader(currentSegment, x12Doc);
        boolean insideGroup = false;
        boolean insideTransaction = false;
        while (segments.hasNext()) {
            currentSegment = segments.next();
            X12Group currentGroup = this.parseGroupHeader(currentSegment, x12Doc);
            x12Doc.addGroupHeader(currentGroup);
            insideGroup = true;
            ArrayList<X12Segment> transactionSet = new ArrayList<X12Segment>();
            while (insideGroup && segments.hasNext()) {
                currentSegment = segments.next();
                if ("ST".equals(currentSegment.getIdentifier())) {
                    if (insideTransaction) {
                        this.handleUnexpectedSegment("SE", currentSegment.getIdentifier());
                        continue;
                    }
                    insideTransaction = true;
                    transactionSet.add(currentSegment);
                    continue;
                }
                if ("SE".equals(currentSegment.getIdentifier())) {
                    if (insideTransaction) {
                        transactionSet.add(currentSegment);
                        this.parseTransactionSet(transactionSet, currentGroup);
                        insideTransaction = false;
                        transactionSet.clear();
                        continue;
                    }
                    this.handleUnexpectedSegment("ST", currentSegment.getIdentifier());
                    continue;
                }
                if (GROUP_TRAILER_ID.equals(currentSegment.getIdentifier())) {
                    if (insideTransaction) {
                        this.handleUnexpectedSegment("SE", currentSegment.getIdentifier());
                        continue;
                    }
                    insideGroup = false;
                    continue;
                }
                transactionSet.add(currentSegment);
            }
            if (insideTransaction) {
                this.handleUnexpectedSegment("SE", currentSegment.getIdentifier());
            }
            if (insideGroup) {
                this.handleUnexpectedSegment(GROUP_TRAILER_ID, currentSegment.getIdentifier());
            }
            this.parseGroupTrailer(currentSegment, currentGroup);
            if (!segments.hasNext()) continue;
            currentSegment = segments.next();
            if (ENVELOPE_TRAILER_ID.equals(currentSegment.getIdentifier())) {
                this.parseInterchangeControlTrailer(currentSegment, x12Doc);
                continue;
            }
            currentSegment = segments.previous();
        }
    }

    private void parseInterchangeControlHeader(X12Segment segment, StandardX12Document x12Doc) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (ENVELOPE_HEADER_ID.equals(segmentIdentifier)) {
            InterchangeControlEnvelope isa = new InterchangeControlEnvelope();
            isa.setAuthorizationInformationQualifier(segment.getElement(1));
            isa.setAuthorizationInformation(segment.getElement(2));
            isa.setSecurityInformationQualifier(segment.getElement(3));
            isa.setSecurityInformation(segment.getElement(4));
            isa.setInterchangeIdQualifier(segment.getElement(5));
            isa.setInterchangeSenderId(segment.getElement(6));
            isa.setInterchangeIdQualifierTwo(segment.getElement(7));
            isa.setInterchangeReceiverId(segment.getElement(8));
            isa.setInterchangeDate(segment.getElement(9));
            isa.setInterchangeTime(segment.getElement(10));
            isa.setInterchangeControlStandardId(segment.getElement(11));
            isa.setInterchangeControlVersion(segment.getElement(12));
            isa.setInterchangeControlNumber(segment.getElement(13));
            isa.setAcknowledgementRequested(segment.getElement(14));
            isa.setUsageIndicator(segment.getElement(15));
            isa.setElementSeparator(segment.getElement(16));
            x12Doc.setInterchangeControlEnvelope(isa);
        } else {
            this.handleUnexpectedSegment(ENVELOPE_HEADER_ID, segmentIdentifier);
        }
    }

    private void parseInterchangeControlTrailer(X12Segment segment, StandardX12Document x12Doc) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (ENVELOPE_TRAILER_ID.equals(segmentIdentifier)) {
            InterchangeControlEnvelope isa = x12Doc.getInterchangeControlEnvelope();
            isa.setNumberOfGroups(ConversionUtil.convertStringToInteger(segment.getElement(1)));
            isa.setTrailerInterchangeControlNumber(segment.getElement(2));
        } else {
            this.handleUnexpectedSegment(ENVELOPE_TRAILER_ID, segmentIdentifier);
        }
    }

    private X12Group parseGroupHeader(X12Segment segment, StandardX12Document x12Doc) {
        LOGGER.debug(segment.getIdentifier());
        X12Group groupHeader = null;
        String segmentIdentifier = segment.getIdentifier();
        if (GROUP_HEADER_ID.equals(segmentIdentifier)) {
            groupHeader = new X12Group();
            groupHeader.setFunctionalCodeId(segment.getElement(1));
            groupHeader.setApplicationSenderCode(segment.getElement(2));
            groupHeader.setApplicationReceiverCode(segment.getElement(3));
            groupHeader.setDate(segment.getElement(4));
            groupHeader.setTime(segment.getElement(5));
            groupHeader.setHeaderGroupControlNumber(segment.getElement(6));
            groupHeader.setResponsibleAgencyCode(segment.getElement(7));
            groupHeader.setVersion(segment.getElement(8));
        } else {
            this.handleUnexpectedSegment(GROUP_HEADER_ID, segmentIdentifier);
        }
        return groupHeader;
    }

    private void parseGroupTrailer(X12Segment segment, X12Group x12Group) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (GROUP_TRAILER_ID.equals(segmentIdentifier)) {
            x12Group.setNumberOfTransactions(ConversionUtil.convertStringToInteger(segment.getElement(1)));
            x12Group.setTrailerGroupControlNumber(segment.getElement(2));
        } else {
            this.handleUnexpectedSegment(GROUP_TRAILER_ID, segmentIdentifier);
        }
    }

    private void parseTransactionSet(List<X12Segment> transactionSegments, X12Group x12Group) {
        if (this.transactionParser != null) {
            X12TransactionSet txSet = this.transactionParser.parseTransactionSet(transactionSegments, x12Group);
            if (txSet != null) {
                x12Group.addTransactionSet(txSet);
            } else if (this.unhandledTransactionSet != null) {
                this.unhandledTransactionSet.unhandledTransactionSet(transactionSegments, x12Group);
            }
        } else {
            LOGGER.warn("No TransactionSetParser has been registered!");
        }
    }
}

