/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.standard;

import com.walmartlabs.x12.X12Segment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class X12Loop {
    public static final String HIERARCHY_LOOP_ID = "HL";
    private String hierarchicalId;
    private String parentHierarchicalId;
    private String code;
    private List<X12Segment> segments;
    private List<X12Loop> childLoops;

    public void addSegment(X12Segment segment) {
        if (this.segments == null) {
            this.segments = new ArrayList<X12Segment>();
        }
        this.segments.add(segment);
    }

    public void addLoop(X12Loop loop) {
        if (this.childLoops == null) {
            this.childLoops = new ArrayList<X12Loop>();
        }
        this.childLoops.add(loop);
    }

    public static boolean isLoopWithCode(X12Loop loop, String desiredCode) {
        Optional<String> os = Optional.ofNullable(loop).map(notNullLoop -> notNullLoop.getCode()).filter(Objects::nonNull).filter(code -> code.equals(desiredCode));
        return os.isPresent();
    }

    public List<X12Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<X12Segment> segments) {
        this.segments = segments;
    }

    public List<X12Loop> getChildLoops() {
        return this.childLoops;
    }

    public void setChildLoops(List<X12Loop> childLoops) {
        this.childLoops = childLoops;
    }

    public String getHierarchicalId() {
        return this.hierarchicalId;
    }

    public void setHierarchicalId(String hierarchicalId) {
        this.hierarchicalId = hierarchicalId;
    }

    public String getParentHierarchicalId() {
        return this.parentHierarchicalId;
    }

    public void setParentHierarchicalId(String parentHierarchicalId) {
        this.parentHierarchicalId = parentHierarchicalId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

