/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.standard.txset;

import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.X12TransactionSet;
import com.walmartlabs.x12.standard.X12Group;
import com.walmartlabs.x12.standard.txset.TransactionSetParser;
import com.walmartlabs.x12.util.ConversionUtil;
import com.walmartlabs.x12.util.X12ParsingUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionSetParserChainable
implements TransactionSetParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransactionSetParserChainable.class);
    private TransactionSetParser nextParser;

    @Override
    public X12TransactionSet parseTransactionSet(List<X12Segment> transactionSegments, X12Group x12Group) {
        if (this.handlesTransactionSet(transactionSegments, x12Group)) {
            return this.doParse(transactionSegments, x12Group);
        }
        if (this.nextParser != null) {
            return this.nextParser.parseTransactionSet(transactionSegments, x12Group);
        }
        return null;
    }

    public boolean registerNextTransactionSetParser(TransactionSetParser txParser) {
        boolean isAdded = false;
        if (txParser != null) {
            if (this.nextParser == null) {
                isAdded = true;
                this.nextParser = txParser;
            } else if (this.nextParser instanceof AbstractTransactionSetParserChainable) {
                isAdded = ((AbstractTransactionSetParserChainable)this.nextParser).registerNextTransactionSetParser(txParser);
            }
        }
        return isAdded;
    }

    protected abstract boolean handlesTransactionSet(List<X12Segment> var1, X12Group var2);

    protected abstract X12TransactionSet doParse(List<X12Segment> var1, X12Group var2);

    protected void parseTransactionSetHeader(X12Segment segment, X12TransactionSet transactionSet) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (!"ST".equals(segmentIdentifier)) {
            throw X12ParsingUtil.handleUnexpectedSegment("ST", segmentIdentifier);
        }
        transactionSet.setTransactionSetIdentifierCode(segment.getElement(1));
        transactionSet.setHeaderControlNumber(segment.getElement(2));
    }

    protected void parseTransactionSetTrailer(X12Segment segment, X12TransactionSet transactionSet) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (!"SE".equals(segmentIdentifier)) {
            throw X12ParsingUtil.handleUnexpectedSegment("SE", segmentIdentifier);
        }
        transactionSet.setExpectedNumberOfSegments(ConversionUtil.convertStringToInteger(segment.getElement(1)));
        transactionSet.setTrailerControlNumber(segment.getElement(2));
    }

    protected void parseTransactionTotals(X12Segment segment, X12TransactionSet asnTx) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (!"CTT".equals(segmentIdentifier)) {
            throw X12ParsingUtil.handleUnexpectedSegment("CTT", segmentIdentifier);
        }
        asnTx.setTransactionLineItems(ConversionUtil.convertStringToInteger(segment.getElement(1)));
    }
}

