/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.standard.txset.asn856;

import com.walmartlabs.x12.SegmentIterator;
import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.X12TransactionSet;
import com.walmartlabs.x12.common.segment.DTMDateTimeReference;
import com.walmartlabs.x12.common.segment.N1PartyIdentification;
import com.walmartlabs.x12.common.segment.parser.DTMDateTimeReferenceParser;
import com.walmartlabs.x12.common.segment.parser.FOBRelatedInstructionsParser;
import com.walmartlabs.x12.common.segment.parser.LINItemIdentificationParser;
import com.walmartlabs.x12.common.segment.parser.N1PartyIdentificationParser;
import com.walmartlabs.x12.common.segment.parser.PIDPartyIdentificationParser;
import com.walmartlabs.x12.common.segment.parser.PKGPackagingParser;
import com.walmartlabs.x12.common.segment.parser.REFReferenceInformationParser;
import com.walmartlabs.x12.common.segment.parser.TD1CarrierDetailParser;
import com.walmartlabs.x12.common.segment.parser.TD3CarrierDetailParser;
import com.walmartlabs.x12.common.segment.parser.TD5CarrierDetailParser;
import com.walmartlabs.x12.exceptions.X12ErrorDetail;
import com.walmartlabs.x12.standard.X12Group;
import com.walmartlabs.x12.standard.X12Loop;
import com.walmartlabs.x12.standard.X12ParsedLoop;
import com.walmartlabs.x12.standard.txset.AbstractTransactionSetParserChainable;
import com.walmartlabs.x12.standard.txset.asn856.AsnTransactionSet;
import com.walmartlabs.x12.standard.txset.asn856.loop.Batch;
import com.walmartlabs.x12.standard.txset.asn856.loop.Item;
import com.walmartlabs.x12.standard.txset.asn856.loop.Order;
import com.walmartlabs.x12.standard.txset.asn856.loop.Pack;
import com.walmartlabs.x12.standard.txset.asn856.loop.Shipment;
import com.walmartlabs.x12.standard.txset.asn856.loop.Tare;
import com.walmartlabs.x12.standard.txset.asn856.segment.parser.MANMarkNumberParser;
import com.walmartlabs.x12.standard.txset.asn856.segment.parser.PALPalletTypeParser;
import com.walmartlabs.x12.standard.txset.asn856.segment.parser.PO4ItemPhysicalDetailParser;
import com.walmartlabs.x12.standard.txset.asn856.segment.parser.PRFPurchaseOrderReferenceParser;
import com.walmartlabs.x12.standard.txset.asn856.segment.parser.SN1ItemDetailParser;
import com.walmartlabs.x12.util.TriConsumer;
import com.walmartlabs.x12.util.X12ParsingUtil;
import com.walmartlabs.x12.util.loop.X12LoopHolder;
import com.walmartlabs.x12.util.loop.X12LoopUtil;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsn856TransactionSetParser
extends AbstractTransactionSetParserChainable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsn856TransactionSetParser.class);
    public static final String ASN_TRANSACTION_TYPE = "856";
    public static final String ASN_TRANSACTION_HEADER = "BSN";
    public static final String ASN_TRANSACTION_TOTALS = "CTT";

    @Override
    protected boolean handlesTransactionSet(List<X12Segment> transactionSegments, X12Group x12Group) {
        return X12ParsingUtil.verifyTransactionSetType(transactionSegments, ASN_TRANSACTION_TYPE);
    }

    @Override
    protected X12TransactionSet doParse(List<X12Segment> transactionSegments, X12Group x12Group) {
        AsnTransactionSet asnTx = null;
        if (CollectionUtils.isNotEmpty(transactionSegments)) {
            asnTx = new AsnTransactionSet();
            this.doParsing(transactionSegments, asnTx);
        }
        return asnTx;
    }

    protected void doParsing(List<X12Segment> transactionSegments, AsnTransactionSet asnTx) {
        SegmentIterator segments = new SegmentIterator(transactionSegments);
        X12Segment currentSegment = null;
        if (segments.hasNext()) {
            currentSegment = segments.next();
            this.parseTransactionSetHeader(currentSegment, asnTx);
        }
        if (segments.hasNext()) {
            currentSegment = segments.next();
            this.parseBeginningSegmentForShipNotice(currentSegment, asnTx);
        }
        this.parseSegmentsBeforeFirstLoop(segments, asnTx);
        this.handleLooping(segments, asnTx);
        this.handleOptionalSegments(segments, asnTx);
        if (!segments.hasNext()) {
            throw X12ParsingUtil.handleUnexpectedSegment("SE", "nothing");
        }
        currentSegment = segments.next();
        this.parseTransactionSetTrailer(currentSegment, asnTx);
    }

    private void parseBeginningSegmentForShipNotice(X12Segment segment, AsnTransactionSet asnTx) {
        LOGGER.debug(segment.getIdentifier());
        String segmentIdentifier = segment.getIdentifier();
        if (!ASN_TRANSACTION_HEADER.equals(segmentIdentifier)) {
            throw X12ParsingUtil.handleUnexpectedSegment(ASN_TRANSACTION_HEADER, segmentIdentifier);
        }
        asnTx.setPurposeCode(segment.getElement(1));
        asnTx.setShipmentIdentification(segment.getElement(2));
        asnTx.setShipmentDate(segment.getElement(3));
        asnTx.setShipmentTime(segment.getElement(4));
        asnTx.setHierarchicalStructureCode(segment.getElement(5));
    }

    private void parseShipmentLoop(X12Loop unparsedLoop, AsnTransactionSet asnTx) {
        LOGGER.debug(unparsedLoop.getCode());
        if (Shipment.isShipmentLoop(unparsedLoop)) {
            Shipment shipment = new Shipment();
            shipment.copyAttributes(unparsedLoop);
            asnTx.setShipment(shipment);
            this.handleLoopSegments(unparsedLoop, shipment, this::doShipmentSegments);
            List<X12Loop> shipmentChildLoops = unparsedLoop.getChildLoops();
            if (CollectionUtils.isNotEmpty(shipmentChildLoops)) {
                shipmentChildLoops.forEach(childLoop -> this.parseOrderLoop((X12Loop)childLoop, shipment, asnTx));
            }
        } else {
            asnTx.addX12ErrorDetailForLoop(new X12ErrorDetail("HL", "03", "first HL is not a shipment it was " + unparsedLoop.getCode()));
        }
    }

    private void parseOrderLoop(X12Loop unparsedLoop, Shipment shipment, AsnTransactionSet asnTx) {
        LOGGER.debug(unparsedLoop.getCode());
        if (Order.isOrderLoop(unparsedLoop)) {
            Order order = new Order();
            order.copyAttributes(unparsedLoop);
            shipment.addParsedChildLoop(order);
            this.handleLoopSegments(unparsedLoop, order, this::doOrderSegments);
            this.parseEachChildrenLoop(unparsedLoop, order);
        } else {
            asnTx.addX12ErrorDetailForLoop(new X12ErrorDetail("HL", "03", "Unexpected child loop", "expected Order HL but got " + unparsedLoop.getCode()));
        }
    }

    private void parseTareLoop(X12Loop unparsedLoop, X12ParsedLoop parentLoop) {
        LOGGER.debug(unparsedLoop.getCode());
        if (Tare.isTareLoop(unparsedLoop)) {
            Tare tare = new Tare();
            tare.copyAttributes(unparsedLoop);
            parentLoop.addParsedChildLoop(tare);
            this.handleLoopSegments(unparsedLoop, tare, this::doTareSegments);
            this.parseEachChildrenLoop(unparsedLoop, tare);
        }
    }

    private void parsePackLoop(X12Loop unparsedLoop, X12ParsedLoop parentLoop) {
        LOGGER.debug(unparsedLoop.getCode());
        if (Pack.isPackLoop(unparsedLoop)) {
            Pack pack = new Pack();
            pack.copyAttributes(unparsedLoop);
            parentLoop.addParsedChildLoop(pack);
            this.handleLoopSegments(unparsedLoop, pack, this::doPackSegments);
            this.parseEachChildrenLoop(unparsedLoop, pack);
        }
    }

    private void parseItemLoop(X12Loop unparsedLoop, X12ParsedLoop parentLoop) {
        LOGGER.debug(unparsedLoop.getCode());
        if (Item.isItemLoop(unparsedLoop)) {
            Item item = new Item();
            item.copyAttributes(unparsedLoop);
            parentLoop.addParsedChildLoop(item);
            this.handleLoopSegments(unparsedLoop, item, this::doItemSegments);
            this.parseEachChildrenLoop(unparsedLoop, item);
        }
    }

    private void parseBatchLoop(X12Loop unparsedLoop, X12ParsedLoop parentLoop) {
        LOGGER.debug(unparsedLoop.getCode());
        if (Batch.isBatchLoop(unparsedLoop)) {
            Batch batch = new Batch();
            batch.copyAttributes(unparsedLoop);
            parentLoop.addParsedChildLoop(batch);
            this.handleLoopSegments(unparsedLoop, batch, this::doBatchSegments);
            this.parseEachChildrenLoop(unparsedLoop, batch);
        }
    }

    private void parseEachChildrenLoop(X12Loop unparsedLoop, X12ParsedLoop parentLoop) {
        List<X12Loop> unparsedLoopChildren = unparsedLoop.getChildLoops();
        if (CollectionUtils.isNotEmpty(unparsedLoopChildren)) {
            unparsedLoopChildren.forEach(childLoop -> this.parseChildrenLoop((X12Loop)childLoop, parentLoop));
        }
    }

    private void parseChildrenLoop(X12Loop unparsedLoop, X12ParsedLoop parentLoop) {
        switch (unparsedLoop.getCode()) {
            case "T": {
                this.parseTareLoop(unparsedLoop, parentLoop);
                break;
            }
            case "P": {
                this.parsePackLoop(unparsedLoop, parentLoop);
                break;
            }
            case "I": {
                this.parseItemLoop(unparsedLoop, parentLoop);
                break;
            }
            case "ZZ": {
                this.parseBatchLoop(unparsedLoop, parentLoop);
                break;
            }
            default: {
                parentLoop.addLoop(unparsedLoop);
            }
        }
    }

    private <T> void handleLoopSegments(X12Loop loop, T loopObject, TriConsumer<X12Segment, SegmentIterator, T> function) {
        List<X12Segment> shipmentSegments = loop.getSegments();
        if (CollectionUtils.isNotEmpty(shipmentSegments)) {
            SegmentIterator segmentIterator = new SegmentIterator(shipmentSegments);
            while (segmentIterator.hasNext()) {
                X12Segment segment = segmentIterator.next();
                LOGGER.debug(segment.getIdentifier());
                function.accept(segment, segmentIterator, loopObject);
            }
        }
    }

    private void doShipmentSegments(X12Segment segment, SegmentIterator segmentIterator, Shipment shipment) {
        switch (segment.getIdentifier()) {
            case "TD1": {
                shipment.addTD1CarrierDetail(TD1CarrierDetailParser.parse(segment));
                break;
            }
            case "TD3": {
                shipment.addTD3CarrierDetail(TD3CarrierDetailParser.parse(segment));
                break;
            }
            case "TD5": {
                shipment.addTD5CarrierDetail(TD5CarrierDetailParser.parse(segment));
                break;
            }
            case "N1": {
                N1PartyIdentification n1 = N1PartyIdentificationParser.handleN1Loop(segment, segmentIterator);
                shipment.addN1PartyIdentification(n1);
                break;
            }
            case "REF": {
                shipment.addReferenceInformation(REFReferenceInformationParser.parse(segment));
                break;
            }
            case "DTM": {
                shipment.addDTMDateTimeReference(DTMDateTimeReferenceParser.parse(segment));
                break;
            }
            case "FOB": {
                shipment.setFob(FOBRelatedInstructionsParser.parse(segment));
                break;
            }
            default: {
                shipment.addUnparsedSegment(segment);
            }
        }
    }

    private void doOrderSegments(X12Segment segment, SegmentIterator segmentIterator, Order order) {
        switch (segment.getIdentifier()) {
            case "PRF": {
                order.setPrf(PRFPurchaseOrderReferenceParser.parse(segment));
                break;
            }
            case "REF": {
                order.addReferenceInformation(REFReferenceInformationParser.parse(segment));
                break;
            }
            case "TD1": {
                order.addTD1CarrierDetail(TD1CarrierDetailParser.parse(segment));
                break;
            }
            case "N1": {
                N1PartyIdentification n1 = N1PartyIdentificationParser.handleN1Loop(segment, segmentIterator);
                order.addN1PartyIdentification(n1);
                break;
            }
            default: {
                order.addUnparsedSegment(segment);
            }
        }
    }

    private void doTareSegments(X12Segment segment, SegmentIterator segmentIterator, Tare tare) {
        switch (segment.getIdentifier()) {
            case "PKG": {
                tare.addPKGPackaging(PKGPackagingParser.parse(segment));
                break;
            }
            case "PAL": {
                tare.setPal(PALPalletTypeParser.parse(segment));
                break;
            }
            case "MAN": {
                tare.addMANMarkNumber(MANMarkNumberParser.parse(segment));
                break;
            }
            default: {
                tare.addUnparsedSegment(segment);
            }
        }
    }

    private void doPackSegments(X12Segment segment, SegmentIterator segmentIterator, Pack pack) {
        switch (segment.getIdentifier()) {
            case "MAN": {
                pack.addMANMarkNumber(MANMarkNumberParser.parse(segment));
                break;
            }
            case "N1": {
                N1PartyIdentification n1 = N1PartyIdentificationParser.handleN1Loop(segment, segmentIterator);
                pack.addN1PartyIdentification(n1);
                break;
            }
            case "TD1": {
                pack.addTD1CarrierDetail(TD1CarrierDetailParser.parse(segment));
                break;
            }
            case "PO4": {
                pack.setPo4(PO4ItemPhysicalDetailParser.parse(segment));
                break;
            }
            case "PID": {
                pack.addPIDProductIdentification(PIDPartyIdentificationParser.parse(segment));
                break;
            }
            case "LIN": {
                pack.setItemIdentifications(LINItemIdentificationParser.parse(segment));
                break;
            }
            case "SN1": {
                pack.setSn1(SN1ItemDetailParser.parse(segment));
                break;
            }
            default: {
                pack.addUnparsedSegment(segment);
            }
        }
    }

    private void doItemSegments(X12Segment segment, SegmentIterator segmentIterator, Item item) {
        switch (segment.getIdentifier()) {
            case "PID": {
                item.addPIDProductIdentification(PIDPartyIdentificationParser.parse(segment));
                break;
            }
            case "LIN": {
                item.setItemIdentifications(LINItemIdentificationParser.parse(segment));
                break;
            }
            case "SN1": {
                item.setSn1(SN1ItemDetailParser.parse(segment));
                break;
            }
            case "REF": {
                item.addReferenceInformation(REFReferenceInformationParser.parse(segment));
                break;
            }
            case "DTM": {
                DTMDateTimeReference dtm = DTMDateTimeReferenceParser.parse(segment);
                item.addDTMDateTimeReference(dtm);
                break;
            }
            default: {
                item.addUnparsedSegment(segment);
            }
        }
    }

    private void doBatchSegments(X12Segment segment, SegmentIterator segmentIterator, Batch batch) {
        switch (segment.getIdentifier()) {
            case "PID": {
                batch.addPIDProductIdentification(PIDPartyIdentificationParser.parse(segment));
                break;
            }
            case "LIN": {
                batch.setItemIdentifications(LINItemIdentificationParser.parse(segment));
                break;
            }
            case "SN1": {
                batch.setSn1(SN1ItemDetailParser.parse(segment));
                break;
            }
            case "N1": {
                N1PartyIdentification n1 = N1PartyIdentificationParser.handleN1Loop(segment, segmentIterator);
                batch.addN1PartyIdentification(n1);
                break;
            }
            case "REF": {
                batch.addReferenceInformation(REFReferenceInformationParser.parse(segment));
                break;
            }
            case "DTM": {
                DTMDateTimeReference dtm = DTMDateTimeReferenceParser.parse(segment);
                batch.addDTMDateTimeReference(dtm);
                break;
            }
            default: {
                batch.addUnparsedSegment(segment);
            }
        }
    }

    protected void parseSegmentsBeforeFirstLoop(SegmentIterator segments, AsnTransactionSet txSet) {
        while (segments.hasNext()) {
            X12Segment currentSegment = segments.next();
            String segmentId = currentSegment.getIdentifier();
            LOGGER.debug(segmentId);
            if (X12LoopUtil.isHierarchicalLoopStart(currentSegment) || "SE".equals(segmentId)) {
                segments.previous();
                break;
            }
            if ("DTM".equals(segmentId)) {
                txSet.addDTMDateTimeReference(DTMDateTimeReferenceParser.parse(currentSegment));
                continue;
            }
            txSet.addUnexpectedSegmentBeforeLoop(currentSegment);
        }
    }

    protected void handleLooping(SegmentIterator segments, AsnTransactionSet asnTx) {
        if (segments.hasNext()) {
            X12Segment currentSegment = segments.next();
            if (X12LoopUtil.isHierarchicalLoopStart(currentSegment)) {
                segments.previous();
                int firstLoopSegmentIndex = segments.currentIndex();
                int indexToSegmentAfterHierarchicalLoops = this.findIndexForSegmentAfterHierarchicalLoops(segments);
                List<X12Segment> loopSegments = segments.subList(firstLoopSegmentIndex, indexToSegmentAfterHierarchicalLoops);
                X12LoopHolder loopHolder = X12LoopUtil.organizeHierarchicalLoops(loopSegments);
                List<X12ErrorDetail> loopErrors = loopHolder.getLoopErrors();
                asnTx.addX12ErrorDetailForLoop(loopErrors);
                List<X12Loop> loops = loopHolder.getLoops();
                this.doLoopParsing(loops, asnTx);
                segments.reset(indexToSegmentAfterHierarchicalLoops);
            } else {
                asnTx.addX12ErrorDetailForLoop(new X12ErrorDetail(currentSegment.getIdentifier(), null, "missing shipment loop"));
                segments.previous();
            }
        }
    }

    private int findIndexForSegmentAfterHierarchicalLoops(SegmentIterator segments) {
        int firstLoopSegmentIndex = segments.currentIndex();
        int indexToSegmentAfterHierarchicalLoops = -1;
        while (segments.hasNext()) {
            X12Segment segment = segments.next();
            if (!ASN_TRANSACTION_TOTALS.equals(segment.getIdentifier()) && !"AMT".equals(segment.getIdentifier()) && !"SE".equals(segment.getIdentifier())) continue;
            indexToSegmentAfterHierarchicalLoops = segments.currentIndex() - 1;
            break;
        }
        if (indexToSegmentAfterHierarchicalLoops == -1) {
            indexToSegmentAfterHierarchicalLoops = segments.currentIndex() - 1;
        }
        segments.reset(firstLoopSegmentIndex);
        return indexToSegmentAfterHierarchicalLoops;
    }

    protected void doLoopParsing(List<X12Loop> loops, AsnTransactionSet asnTx) {
        if (CollectionUtils.isNotEmpty(loops) && loops.size() == 1) {
            X12Loop firstLoop = loops.get(0);
            this.parseShipmentLoop(firstLoop, asnTx);
        } else {
            asnTx.addX12ErrorDetailForLoop(new X12ErrorDetail("HL", null, "expected one top level Shipment HL"));
        }
    }

    private void handleOptionalSegments(SegmentIterator segments, AsnTransactionSet genericTx) {
        while (segments.hasNext()) {
            X12Segment currentSegment = segments.next();
            String segmentId = currentSegment.getIdentifier();
            if (ASN_TRANSACTION_TOTALS.equals(segmentId)) {
                this.parseTransactionTotals(currentSegment, genericTx);
                continue;
            }
            segments.previous();
            break;
        }
    }
}

