/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.standard.txset.asn856.loop;

import com.walmartlabs.x12.common.segment.DTMDateTimeReference;
import com.walmartlabs.x12.common.segment.LINItemIdentification;
import com.walmartlabs.x12.common.segment.N1PartyIdentification;
import com.walmartlabs.x12.common.segment.PIDProductIdentification;
import com.walmartlabs.x12.common.segment.REFReferenceInformation;
import com.walmartlabs.x12.standard.X12Loop;
import com.walmartlabs.x12.standard.X12ParsedLoop;
import com.walmartlabs.x12.standard.txset.asn856.segment.SN1ItemDetail;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class Batch
extends X12ParsedLoop {
    public static final String BATCH_LOOP_CODE = "ZZ";
    private List<PIDProductIdentification> productIdentifications;
    private SN1ItemDetail sn1;
    private List<LINItemIdentification> itemIdentifications;
    private List<N1PartyIdentification> n1PartyIdentifications;
    private List<DTMDateTimeReference> dtmReferences;
    private List<REFReferenceInformation> refList;

    public static boolean isBatchLoop(X12Loop loop) {
        return X12Loop.isLoopWithCode(loop, BATCH_LOOP_CODE);
    }

    public void addReferenceInformation(REFReferenceInformation ref) {
        if (CollectionUtils.isEmpty(this.refList)) {
            this.refList = new ArrayList<REFReferenceInformation>();
        }
        this.refList.add(ref);
    }

    public void addLINItemIdentification(LINItemIdentification lin) {
        if (CollectionUtils.isEmpty(this.itemIdentifications)) {
            this.itemIdentifications = new ArrayList<LINItemIdentification>();
        }
        this.itemIdentifications.add(lin);
    }

    public void addPIDProductIdentification(PIDProductIdentification pid) {
        if (CollectionUtils.isEmpty(this.productIdentifications)) {
            this.productIdentifications = new ArrayList<PIDProductIdentification>();
        }
        this.productIdentifications.add(pid);
    }

    public void addN1PartyIdentification(N1PartyIdentification n1) {
        if (CollectionUtils.isEmpty(this.n1PartyIdentifications)) {
            this.n1PartyIdentifications = new ArrayList<N1PartyIdentification>();
        }
        this.n1PartyIdentifications.add(n1);
    }

    public void addDTMDateTimeReference(DTMDateTimeReference dtm) {
        if (CollectionUtils.isEmpty(this.dtmReferences)) {
            this.dtmReferences = new ArrayList<DTMDateTimeReference>();
        }
        this.dtmReferences.add(dtm);
    }

    public List<PIDProductIdentification> getProductIdentifications() {
        return this.productIdentifications;
    }

    public void setProductIdentifications(List<PIDProductIdentification> productIdentifications) {
        this.productIdentifications = productIdentifications;
    }

    public SN1ItemDetail getSn1() {
        return this.sn1;
    }

    public void setSn1(SN1ItemDetail sn1) {
        this.sn1 = sn1;
    }

    public List<LINItemIdentification> getItemIdentifications() {
        return this.itemIdentifications;
    }

    public void setItemIdentifications(List<LINItemIdentification> itemIdentifications) {
        this.itemIdentifications = itemIdentifications;
    }

    public List<N1PartyIdentification> getN1PartyIdentifications() {
        return this.n1PartyIdentifications;
    }

    public void setN1PartyIdentifications(List<N1PartyIdentification> n1PartyIdentifications) {
        this.n1PartyIdentifications = n1PartyIdentifications;
    }

    public List<REFReferenceInformation> getRefList() {
        return this.refList;
    }

    public void setRefList(List<REFReferenceInformation> refList) {
        this.refList = refList;
    }

    public List<DTMDateTimeReference> getDtmReferences() {
        return this.dtmReferences;
    }

    public void setDtmReferences(List<DTMDateTimeReference> dtmReferences) {
        this.dtmReferences = dtmReferences;
    }
}

