/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.standard.txset.asn856.loop;

import com.walmartlabs.x12.common.segment.N1PartyIdentification;
import com.walmartlabs.x12.common.segment.REFReferenceInformation;
import com.walmartlabs.x12.common.segment.TD1CarrierDetail;
import com.walmartlabs.x12.standard.X12Loop;
import com.walmartlabs.x12.standard.X12ParsedLoop;
import com.walmartlabs.x12.standard.txset.asn856.segment.PRFPurchaseOrderReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class Order
extends X12ParsedLoop {
    public static final String ORDER_LOOP_CODE = "O";
    private PRFPurchaseOrderReference prf;
    private List<TD1CarrierDetail> td1List;
    private List<REFReferenceInformation> refList;
    private List<N1PartyIdentification> n1PartyIdentifications;

    public static boolean isOrderLoop(X12Loop loop) {
        return X12Loop.isLoopWithCode(loop, ORDER_LOOP_CODE);
    }

    public void addTD1CarrierDetail(TD1CarrierDetail td1) {
        if (CollectionUtils.isEmpty(this.td1List)) {
            this.td1List = new ArrayList<TD1CarrierDetail>();
        }
        this.td1List.add(td1);
    }

    public void addReferenceInformation(REFReferenceInformation ref) {
        if (CollectionUtils.isEmpty(this.refList)) {
            this.refList = new ArrayList<REFReferenceInformation>();
        }
        this.refList.add(ref);
    }

    public void addN1PartyIdentification(N1PartyIdentification n1) {
        if (CollectionUtils.isEmpty(this.n1PartyIdentifications)) {
            this.n1PartyIdentifications = new ArrayList<N1PartyIdentification>();
        }
        this.n1PartyIdentifications.add(n1);
    }

    public PRFPurchaseOrderReference getPrf() {
        return this.prf;
    }

    public void setPrf(PRFPurchaseOrderReference prf) {
        this.prf = prf;
    }

    public List<REFReferenceInformation> getRefList() {
        return this.refList;
    }

    public void setRefList(List<REFReferenceInformation> refList) {
        this.refList = refList;
    }

    public List<TD1CarrierDetail> getTd1List() {
        return this.td1List;
    }

    public void setTd1List(List<TD1CarrierDetail> td1List) {
        this.td1List = td1List;
    }

    public List<N1PartyIdentification> getN1PartyIdentifications() {
        return this.n1PartyIdentifications;
    }

    public void setN1PartyIdentifications(List<N1PartyIdentification> n1PartyIdentifications) {
        this.n1PartyIdentifications = n1PartyIdentifications;
    }
}

