/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.standard.txset.asn856.loop;

import com.walmartlabs.x12.common.segment.LINItemIdentification;
import com.walmartlabs.x12.common.segment.N1PartyIdentification;
import com.walmartlabs.x12.common.segment.PIDProductIdentification;
import com.walmartlabs.x12.common.segment.TD1CarrierDetail;
import com.walmartlabs.x12.standard.X12Loop;
import com.walmartlabs.x12.standard.X12ParsedLoop;
import com.walmartlabs.x12.standard.txset.asn856.segment.MANMarkNumber;
import com.walmartlabs.x12.standard.txset.asn856.segment.PO4ItemPhysicalDetail;
import com.walmartlabs.x12.standard.txset.asn856.segment.SN1ItemDetail;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class Pack
extends X12ParsedLoop {
    public static final String PACK_LOOP_CODE = "P";
    private List<MANMarkNumber> manList;
    private List<N1PartyIdentification> n1PartyIdentifications;
    private PO4ItemPhysicalDetail po4;
    private List<PIDProductIdentification> productIdentifications;
    private List<TD1CarrierDetail> td1List;
    private SN1ItemDetail sn1;
    private List<LINItemIdentification> itemIdentifications;

    public static boolean isPackLoop(X12Loop loop) {
        return X12Loop.isLoopWithCode(loop, PACK_LOOP_CODE);
    }

    public void addTD1CarrierDetail(TD1CarrierDetail td1) {
        if (CollectionUtils.isEmpty(this.td1List)) {
            this.td1List = new ArrayList<TD1CarrierDetail>();
        }
        this.td1List.add(td1);
    }

    public void addLINItemIdentification(LINItemIdentification lin) {
        if (CollectionUtils.isEmpty(this.itemIdentifications)) {
            this.itemIdentifications = new ArrayList<LINItemIdentification>();
        }
        this.itemIdentifications.add(lin);
    }

    public void addPIDProductIdentification(PIDProductIdentification pid) {
        if (CollectionUtils.isEmpty(this.productIdentifications)) {
            this.productIdentifications = new ArrayList<PIDProductIdentification>();
        }
        this.productIdentifications.add(pid);
    }

    public void addMANMarkNumber(MANMarkNumber man) {
        if (CollectionUtils.isEmpty(this.manList)) {
            this.manList = new ArrayList<MANMarkNumber>();
        }
        this.manList.add(man);
    }

    public void addN1PartyIdentification(N1PartyIdentification n1) {
        if (CollectionUtils.isEmpty(this.n1PartyIdentifications)) {
            this.n1PartyIdentifications = new ArrayList<N1PartyIdentification>();
        }
        this.n1PartyIdentifications.add(n1);
    }

    public PO4ItemPhysicalDetail getPo4() {
        return this.po4;
    }

    public void setPo4(PO4ItemPhysicalDetail po4) {
        this.po4 = po4;
    }

    public List<PIDProductIdentification> getProductIdentifications() {
        return this.productIdentifications;
    }

    public void setProductIdentifications(List<PIDProductIdentification> productIdentifications) {
        this.productIdentifications = productIdentifications;
    }

    public SN1ItemDetail getSn1() {
        return this.sn1;
    }

    public void setSn1(SN1ItemDetail sn1) {
        this.sn1 = sn1;
    }

    public List<LINItemIdentification> getItemIdentifications() {
        return this.itemIdentifications;
    }

    public void setItemIdentifications(List<LINItemIdentification> itemIdentifications) {
        this.itemIdentifications = itemIdentifications;
    }

    public List<MANMarkNumber> getManList() {
        return this.manList;
    }

    public void setManList(List<MANMarkNumber> manList) {
        this.manList = manList;
    }

    public List<TD1CarrierDetail> getTd1List() {
        return this.td1List;
    }

    public void setTd1List(List<TD1CarrierDetail> td1List) {
        this.td1List = td1List;
    }

    public List<N1PartyIdentification> getN1PartyIdentifications() {
        return this.n1PartyIdentifications;
    }

    public void setN1PartyIdentifications(List<N1PartyIdentification> n1PartyIdentifications) {
        this.n1PartyIdentifications = n1PartyIdentifications;
    }
}

