/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.standard.txset.asn856.loop;

import com.walmartlabs.x12.common.segment.DTMDateTimeReference;
import com.walmartlabs.x12.common.segment.FOBRelatedInstructions;
import com.walmartlabs.x12.common.segment.N1PartyIdentification;
import com.walmartlabs.x12.common.segment.REFReferenceInformation;
import com.walmartlabs.x12.common.segment.TD1CarrierDetail;
import com.walmartlabs.x12.common.segment.TD3CarrierDetail;
import com.walmartlabs.x12.common.segment.TD5CarrierDetail;
import com.walmartlabs.x12.standard.X12Loop;
import com.walmartlabs.x12.standard.X12ParsedLoop;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class Shipment
extends X12ParsedLoop {
    public static final String SHIPMENT_LOOP_CODE = "S";
    private List<TD1CarrierDetail> td1List;
    private List<TD5CarrierDetail> td5List;
    private List<TD3CarrierDetail> td3List;
    private List<REFReferenceInformation> refList;
    private List<DTMDateTimeReference> dtmReferences;
    private FOBRelatedInstructions fob;
    private List<N1PartyIdentification> n1PartyIdentifications;

    public static boolean isShipmentLoop(X12Loop loop) {
        return X12Loop.isLoopWithCode(loop, SHIPMENT_LOOP_CODE);
    }

    public void addTD1CarrierDetail(TD1CarrierDetail td1) {
        if (CollectionUtils.isEmpty(this.td1List)) {
            this.td1List = new ArrayList<TD1CarrierDetail>();
        }
        this.td1List.add(td1);
    }

    public void addTD5CarrierDetail(TD5CarrierDetail td5) {
        if (CollectionUtils.isEmpty(this.td5List)) {
            this.td5List = new ArrayList<TD5CarrierDetail>();
        }
        this.td5List.add(td5);
    }

    public void addTD3CarrierDetail(TD3CarrierDetail td3) {
        if (CollectionUtils.isEmpty(this.td3List)) {
            this.td3List = new ArrayList<TD3CarrierDetail>();
        }
        this.td3List.add(td3);
    }

    public void addReferenceInformation(REFReferenceInformation ref) {
        if (CollectionUtils.isEmpty(this.refList)) {
            this.refList = new ArrayList<REFReferenceInformation>();
        }
        this.refList.add(ref);
    }

    public void addDTMDateTimeReference(DTMDateTimeReference dtm) {
        if (CollectionUtils.isEmpty(this.dtmReferences)) {
            this.dtmReferences = new ArrayList<DTMDateTimeReference>();
        }
        this.dtmReferences.add(dtm);
    }

    public void addN1PartyIdentification(N1PartyIdentification n1) {
        if (CollectionUtils.isEmpty(this.n1PartyIdentifications)) {
            this.n1PartyIdentifications = new ArrayList<N1PartyIdentification>();
        }
        this.n1PartyIdentifications.add(n1);
    }

    public List<N1PartyIdentification> getN1PartyIdentifications() {
        return this.n1PartyIdentifications;
    }

    public void setN1PartyIdentifications(List<N1PartyIdentification> n1PartyIdentifications) {
        this.n1PartyIdentifications = n1PartyIdentifications;
    }

    public List<TD1CarrierDetail> getTd1List() {
        return this.td1List;
    }

    public void setTd1List(List<TD1CarrierDetail> td1List) {
        this.td1List = td1List;
    }

    public List<TD5CarrierDetail> getTd5List() {
        return this.td5List;
    }

    public void setTd5List(List<TD5CarrierDetail> td5List) {
        this.td5List = td5List;
    }

    public List<TD3CarrierDetail> getTd3List() {
        return this.td3List;
    }

    public void setTd3List(List<TD3CarrierDetail> td3List) {
        this.td3List = td3List;
    }

    public List<DTMDateTimeReference> getDtmReferences() {
        return this.dtmReferences;
    }

    public void setDtmReferences(List<DTMDateTimeReference> dtmReferences) {
        this.dtmReferences = dtmReferences;
    }

    public List<REFReferenceInformation> getRefList() {
        return this.refList;
    }

    public void setRefList(List<REFReferenceInformation> refList) {
        this.refList = refList;
    }

    public FOBRelatedInstructions getFob() {
        return this.fob;
    }

    public void setFob(FOBRelatedInstructions fob) {
        this.fob = fob;
    }
}

