/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.standard.txset.generic;

import com.walmartlabs.x12.SegmentIterator;
import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.X12TransactionSet;
import com.walmartlabs.x12.exceptions.X12ErrorDetail;
import com.walmartlabs.x12.standard.X12Group;
import com.walmartlabs.x12.standard.X12Loop;
import com.walmartlabs.x12.standard.txset.AbstractTransactionSetParserChainable;
import com.walmartlabs.x12.standard.txset.generic.GenericTransactionSet;
import com.walmartlabs.x12.util.X12ParsingUtil;
import com.walmartlabs.x12.util.loop.X12LoopHolder;
import com.walmartlabs.x12.util.loop.X12LoopUtil;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTransactionSetParser
extends AbstractTransactionSetParserChainable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericTransactionSetParser.class);

    @Override
    protected boolean handlesTransactionSet(List<X12Segment> transactionSegments, X12Group x12Group) {
        return true;
    }

    @Override
    protected X12TransactionSet doParse(List<X12Segment> transactionSegments, X12Group x12Group) {
        GenericTransactionSet genericTxSet = null;
        if (CollectionUtils.isNotEmpty(transactionSegments)) {
            genericTxSet = new GenericTransactionSet();
            this.doParsing(transactionSegments, genericTxSet);
        }
        return genericTxSet;
    }

    protected void doParsing(List<X12Segment> transactionSegments, GenericTransactionSet genericTx) {
        SegmentIterator segments = new SegmentIterator(transactionSegments);
        X12Segment currentSegment = null;
        if (segments.hasNext()) {
            currentSegment = segments.next();
            this.parseTransactionSetHeader(currentSegment, genericTx);
        }
        if (segments.hasNext()) {
            currentSegment = segments.next();
            if (this.isLoopSegmentOrOptionalSegmentOrEndingSegment(currentSegment)) {
                throw X12ParsingUtil.handleUnexpectedSegment("Beginning", currentSegment.getIdentifier());
            }
            genericTx.setBeginningSegment(currentSegment);
        }
        this.parseSegmentsBeforeHierarchyLoops(segments, genericTx);
        this.handleLooping(segments, genericTx);
        this.handleOptionalSegments(segments, genericTx);
        if (!segments.hasNext()) {
            throw X12ParsingUtil.handleUnexpectedSegment("SE", "nothing");
        }
        currentSegment = segments.next();
        this.parseTransactionSetTrailer(currentSegment, genericTx);
    }

    protected void parseSegmentsBeforeHierarchyLoops(SegmentIterator segments, GenericTransactionSet genericTx) {
        while (segments.hasNext()) {
            X12Segment currentSegment = segments.next();
            if (this.isLoopSegmentOrOptionalSegmentOrEndingSegment(currentSegment)) {
                segments.previous();
                break;
            }
            LOGGER.debug(currentSegment.getIdentifier());
            genericTx.addX12Segment(currentSegment);
        }
    }

    private boolean isLoopSegmentOrOptionalSegmentOrEndingSegment(X12Segment segment) {
        return X12LoopUtil.isHierarchicalLoopStart(segment) || "CTT".equals(segment.getIdentifier()) || "AMT".equals(segment.getIdentifier()) || "SE".equals(segment.getIdentifier());
    }

    private void handleOptionalSegments(SegmentIterator segments, GenericTransactionSet genericTx) {
        while (segments.hasNext()) {
            X12Segment currentSegment = segments.next();
            String segmentId = currentSegment.getIdentifier();
            if ("CTT".equals(segmentId)) {
                this.parseTransactionTotals(currentSegment, genericTx);
                continue;
            }
            if ("AMT".equals(segmentId)) continue;
            segments.previous();
            break;
        }
    }

    protected void handleLooping(SegmentIterator segments, GenericTransactionSet genericTx) {
        if (segments.hasNext()) {
            X12Segment currentSegment = segments.next();
            if (X12LoopUtil.isHierarchicalLoopStart(currentSegment)) {
                segments.previous();
                int firstLoopSegmentIndex = segments.currentIndex();
                int indexToSegmentAfterHierarchicalLoops = this.findIndexForSegmentAfterHierarchicalLoops(segments);
                List<X12Segment> loopSegments = segments.subList(firstLoopSegmentIndex, indexToSegmentAfterHierarchicalLoops);
                X12LoopHolder loopHolder = X12LoopUtil.organizeHierarchicalLoops(loopSegments);
                List<X12Loop> loops = loopHolder.getLoops();
                genericTx.setLoops(loops);
                List<X12ErrorDetail> loopErrors = loopHolder.getLoopErrors();
                genericTx.addX12ErrorDetailForLoop(loopErrors);
                segments.reset(indexToSegmentAfterHierarchicalLoops);
            } else {
                segments.previous();
            }
        }
    }

    private int findIndexForSegmentAfterHierarchicalLoops(SegmentIterator segments) {
        int firstLoopSegmentIndex = segments.currentIndex();
        int indexToSegmentAfterHierarchicalLoops = -1;
        while (segments.hasNext()) {
            X12Segment segment = segments.next();
            if (!"CTT".equals(segment.getIdentifier()) && !"AMT".equals(segment.getIdentifier()) && !"SE".equals(segment.getIdentifier())) continue;
            indexToSegmentAfterHierarchicalLoops = segments.currentIndex() - 1;
            break;
        }
        if (indexToSegmentAfterHierarchicalLoops == -1) {
            indexToSegmentAfterHierarchicalLoops = segments.currentIndex() - 1;
        }
        segments.reset(firstLoopSegmentIndex);
        return indexToSegmentAfterHierarchicalLoops;
    }
}

