/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.util;

import com.walmartlabs.x12.X12Segment;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class SourceToSegmentUtil {
    public static final Character DEFAULT_DATA_ELEMENT_SEPARATOR = Character.valueOf('*');
    public static final Character DEFAULT_REPETITION_ELEMENT_SEPARATOR = Character.valueOf('^');
    public static final Character DEFAULT_COMPOSITE_ELEMENT_SEPARATOR = Character.valueOf(':');
    public static final Character DEFAULT_SEGMENT_SEPARATOR = Character.valueOf('~');
    public static final int DATA_ELEMENT_SEPARATOR_INDEX = 3;
    public static final int REPETITION_ELEMENT_SEPARATOR_INDEX = 82;
    public static final int COMPOSITE_ELEMENT_SEPARATOR_INDEX = 104;
    public static final int SEGMENT_SEPARATOR_INDEX = 105;

    public static List<X12Segment> splitSourceDataIntoSegments(String sourceData) {
        List<X12Segment> segments = SourceToSegmentUtil.splitSourceDataIntoSegments(sourceData, "\\r?\\n");
        if (segments != null && segments.size() > 1) {
            return segments;
        }
        String segmentDelimiterRegex = "\\" + SourceToSegmentUtil.findSegmentDelimiterCharacter(sourceData);
        return SourceToSegmentUtil.splitSourceDataIntoSegments(sourceData, segmentDelimiterRegex);
    }

    private static List<X12Segment> splitSourceDataIntoSegments(String sourceData, String segmentSeparatorRegEx) {
        if (StringUtils.isEmpty((CharSequence)sourceData) || StringUtils.isEmpty((CharSequence)segmentSeparatorRegEx)) {
            return Collections.emptyList();
        }
        Character segmentDataElementDelimiter = SourceToSegmentUtil.findElementDelimiterCharacter(sourceData);
        String[] segments = sourceData.split(segmentSeparatorRegEx);
        return Arrays.stream(segments).map(segment -> new X12Segment((String)segment, segmentDataElementDelimiter)).collect(Collectors.toList());
    }

    private static Character findSegmentDelimiterCharacter(String sourceData) {
        if (sourceData != null && sourceData.length() > 105) {
            return Character.valueOf(sourceData.charAt(105));
        }
        return null;
    }

    private static Character findElementDelimiterCharacter(String sourceData) {
        if (sourceData != null && sourceData.length() > 3) {
            return Character.valueOf(sourceData.charAt(3));
        }
        return null;
    }

    private SourceToSegmentUtil() {
    }
}

