/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.util;

import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.exceptions.X12ErrorDetail;
import com.walmartlabs.x12.exceptions.X12ParserException;
import java.util.List;

public final class X12ParsingUtil {
    public static Integer parseVersion(String versionValue) {
        if (versionValue != null && !versionValue.isEmpty()) {
            try {
                String versionNum = X12ParsingUtil.remove0LeftPadding(versionValue).replace("UCS", "");
                return Integer.valueOf(versionNum);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public static X12ParserException handleUnexpectedSegment(String expectedSegmentId, String actualSegmentId) {
        return new X12ParserException(X12ParsingUtil.generateUnexpectedSegmentDetail(expectedSegmentId, actualSegmentId));
    }

    public static X12ErrorDetail generateUnexpectedSegmentDetail(String expectedSegmentId, String actualSegmentId) {
        StringBuilder sb = new StringBuilder("expected ");
        sb.append(expectedSegmentId);
        sb.append(" segment but found ");
        sb.append(actualSegmentId);
        return new X12ErrorDetail(actualSegmentId, null, "expected one segment but found another", sb.toString());
    }

    public static boolean isValidEnvelope(List<X12Segment> segmentList, String headerIdentifier, String trailerIdentifier) {
        boolean isValidEnvelope = false;
        if (segmentList != null && headerIdentifier != null && trailerIdentifier != null) {
            int segmentCount = segmentList.size();
            int lastSegmentIndex = segmentCount - 1;
            if (segmentCount > 1) {
                X12Segment headerSegment = segmentList.get(0);
                X12Segment trailerSegment = segmentList.get(lastSegmentIndex);
                if (headerIdentifier.equals(headerSegment.getIdentifier()) && trailerIdentifier.equals(trailerSegment.getIdentifier())) {
                    isValidEnvelope = true;
                }
            }
        }
        return isValidEnvelope;
    }

    public static boolean verifyTransactionSetType(List<X12Segment> segmentList, String transactionType) {
        String segmentType;
        X12Segment firstSegment;
        boolean isTransactionType = false;
        if (segmentList != null && !segmentList.isEmpty() && transactionType != null && X12ParsingUtil.isValidEnvelope(segmentList, "ST", "SE") && (firstSegment = segmentList.get(0)) != null && transactionType.equals(segmentType = firstSegment.getElement(1))) {
            isTransactionType = true;
        }
        return isTransactionType;
    }

    private static String remove0LeftPadding(String value) {
        return value.replaceFirst("^0+(?!$)", "");
    }

    private X12ParsingUtil() {
    }
}

