/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.util.checksum;

import com.walmartlabs.x12.util.checksum.Checksum;

public class BarCodeMod10Checksum
implements Checksum {
    private static final int THREE = 3;
    private static final int TEN = 10;

    @Override
    public String generateChecksumDigit(byte[] documentAsBytes) {
        if (documentAsBytes != null) {
            return this.generateCheckSumUsingBarCodeMod10(new String(documentAsBytes));
        }
        return null;
    }

    @Override
    public String generateChecksumDigit(String documentAsString) {
        return this.generateCheckSumUsingBarCodeMod10(documentAsString);
    }

    private String generateCheckSumUsingBarCodeMod10(String inputValue) {
        if (inputValue != null && inputValue.length() > 0) {
            StringBuilder sb = new StringBuilder(inputValue);
            String reversedNumber = sb.reverse().toString();
            char[] val = reversedNumber.toCharArray();
            int even = 0;
            int odd = 0;
            int i = 0;
            while (i < val.length) {
                int currentVal = Integer.parseInt(String.valueOf(val[i]));
                if (i % 2 == 0) {
                    even = currentVal + even;
                } else {
                    odd = currentVal + odd;
                }
                ++i;
            }
            int cd = (even * 3 + odd) % 10;
            if (cd != 0) {
                cd = 10 - cd;
            }
            return Integer.toString(cd);
        }
        return null;
    }
}

