/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.util.checksum;

import com.walmartlabs.x12.util.checksum.Checksum;

public class LuhnMod10Checksum
implements Checksum {
    private static final int NINE = 9;
    private static final int TEN = 10;

    @Override
    public String generateChecksumDigit(byte[] documentAsBytes) {
        if (documentAsBytes != null) {
            return this.generateCheckSumUsingLuhnMod10(new String(documentAsBytes));
        }
        return null;
    }

    @Override
    public String generateChecksumDigit(String documentAsString) {
        return this.generateCheckSumUsingLuhnMod10(documentAsString);
    }

    private String generateCheckSumUsingLuhnMod10(String inputValue) {
        if (inputValue != null && inputValue.length() > 0) {
            StringBuilder sb = new StringBuilder(inputValue);
            String reversedNumber = sb.reverse().toString();
            char[] val = reversedNumber.toCharArray();
            int sum = 0;
            int i = 0;
            while (i < val.length) {
                int currentVal;
                int calcVal = currentVal = Integer.parseInt(String.valueOf(val[i]));
                if (i % 2 == 0) {
                    int product = currentVal * 2;
                    calcVal = product > 9 ? product - 9 : product;
                }
                sum += calcVal;
                ++i;
            }
            int cd = sum * 9 % 10;
            return Integer.toString(cd);
        }
        return null;
    }
}

