/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.util.loop;

import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.exceptions.X12ErrorDetail;
import com.walmartlabs.x12.standard.X12Loop;
import com.walmartlabs.x12.util.X12ParsingUtil;
import com.walmartlabs.x12.util.loop.X12LoopHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class X12LoopUtil {
    private static final String MISSING_PARENT_ERROR = "HL segment is missing parent";
    private static final String ALREADY_EXISTS_ERROR = "HL segment already exists";

    public static boolean isHierarchicalLoopStart(X12Segment segment) {
        return segment != null && "HL".equals(segment.getIdentifier());
    }

    public static X12LoopHolder organizeHierarchicalLoops(List<X12Segment> segmentList) {
        X12LoopHolder loopHolder = new X12LoopHolder();
        if (segmentList != null && !segmentList.isEmpty()) {
            X12Segment firstSegment = segmentList.get(0);
            if (X12LoopUtil.isHierarchicalLoopStart(firstSegment)) {
                loopHolder = X12LoopUtil.processLoops(segmentList);
            } else {
                String actualSegment = firstSegment != null ? firstSegment.getIdentifier() : "";
                loopHolder.addX12ErrorDetail(X12ParsingUtil.generateUnexpectedSegmentDetail("HL", actualSegment));
            }
        }
        return loopHolder;
    }

    private static X12LoopHolder processLoops(List<X12Segment> segmentList) {
        X12LoopHolder loopHolder = new X12LoopHolder();
        ArrayList<X12Loop> loops = new ArrayList<X12Loop>();
        loopHolder.setLoops(loops);
        String currLoopId = null;
        HashMap<String, X12Loop> loopMap = new HashMap<String, X12Loop>();
        for (X12Segment x12Segment : segmentList) {
            if (X12LoopUtil.isHierarchicalLoopStart(x12Segment)) {
                String loopId;
                X12Loop loop = X12LoopUtil.buildHierarchicalLoop(x12Segment);
                if (loop.getParentHierarchicalId() == null || loop.getParentHierarchicalId().trim().isEmpty()) {
                    loops.add(loop);
                }
                if (loopMap.containsKey(loopId = loop.getHierarchicalId())) {
                    X12ErrorDetail loopError = X12LoopUtil.loopAlreadyExistsErrorDetail(loop);
                    loopHolder.addX12ErrorDetail(loopError);
                } else {
                    loopMap.put(loop.getHierarchicalId(), loop);
                }
                currLoopId = loopId;
                X12LoopUtil.handleParentLoop(loop, loopMap, loopHolder);
                continue;
            }
            X12Loop currentLoop = (X12Loop)loopMap.get(currLoopId);
            currentLoop.addSegment(x12Segment);
        }
        return loopHolder;
    }

    private static X12Loop buildHierarchicalLoop(X12Segment x12Segment) {
        String loopId = x12Segment.getElement(1);
        String parentLoopId = x12Segment.getElement(2);
        X12Loop loop = new X12Loop();
        loop.setHierarchicalId(loopId);
        loop.setParentHierarchicalId(parentLoopId);
        loop.setCode(x12Segment.getElement(3));
        return loop;
    }

    private static void handleParentLoop(X12Loop loop, Map<String, X12Loop> loopMap, X12LoopHolder loopHolder) {
        String parentLoopId = loop.getParentHierarchicalId();
        if (parentLoopId != null && !parentLoopId.isEmpty()) {
            X12Loop parentLoop = loopMap.get(parentLoopId);
            if (parentLoop != null) {
                parentLoop.addLoop(loop);
            } else {
                X12ErrorDetail loopError = X12LoopUtil.loopMissingParentErrorDetail(loop);
                loopHolder.addX12ErrorDetail(loopError);
            }
        }
    }

    private static X12ErrorDetail loopAlreadyExistsErrorDetail(X12Loop loop) {
        StringBuilder sb = new StringBuilder();
        sb.append("HL segment with id (").append(loop.getHierarchicalId()).append(") already exists");
        return new X12ErrorDetail("HL", null, ALREADY_EXISTS_ERROR, sb.toString());
    }

    private static X12ErrorDetail loopMissingParentErrorDetail(X12Loop loop) {
        StringBuilder sb = new StringBuilder();
        sb.append("HL segment with id (").append(loop.getHierarchicalId()).append(")");
        sb.append(" is missing parent (").append(loop.getParentHierarchicalId()).append(")");
        return new X12ErrorDetail("HL", null, MISSING_PARENT_ERROR, sb.toString());
    }

    private X12LoopUtil() {
    }
}

