/*
 * Decompiled with CFR 0.152.
 */
package com.walmartlabs.x12.util.split;

import com.walmartlabs.x12.SegmentIterator;
import com.walmartlabs.x12.X12Segment;
import com.walmartlabs.x12.exceptions.X12ErrorDetail;
import com.walmartlabs.x12.exceptions.X12ParserException;
import com.walmartlabs.x12.rule.X12Rule;
import com.walmartlabs.x12.util.SourceToSegmentUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class X12TransactionSplitter {
    private static final String EOL = "\r\n";
    private List<X12Rule> rules;

    public List<String> split(String sourceData) {
        if (StringUtils.isEmpty((CharSequence)sourceData)) {
            return Collections.emptyList();
        }
        List<X12Segment> segmentList = SourceToSegmentUtil.splitSourceDataIntoSegments(sourceData.trim());
        return this.split(segmentList);
    }

    public List<String> split(List<X12Segment> segmentList) {
        if (CollectionUtils.isEmpty(segmentList)) {
            return Collections.emptyList();
        }
        this.runRules(segmentList);
        List<TransactionHolder> transactionHolders = this.doParse(segmentList);
        return this.doSplit(transactionHolders);
    }

    public void registerX12Rule(X12Rule rule) {
        if (this.rules == null) {
            this.rules = new ArrayList<X12Rule>();
        }
        this.rules.add(rule);
    }

    public void resetX12Rules() {
        this.rules = null;
    }

    private List<TransactionHolder> doParse(List<X12Segment> segmentList) {
        ArrayList<TransactionHolder> transactionHolders = new ArrayList<TransactionHolder>();
        X12Segment isaHeader = null;
        X12Segment iseTrailer = null;
        SegmentIterator segments = new SegmentIterator(segmentList);
        X12Segment currentSegment = segments.next();
        String currentSegmentId = currentSegment.getIdentifier();
        if ("ISA".equals(currentSegmentId)) {
            isaHeader = currentSegment;
        } else {
            this.throwParserException("ISA", currentSegmentId);
        }
        X12Segment lastSegment = segmentList.get(segmentList.size() - 1);
        if ("IEA".equals(lastSegment.getIdentifier())) {
            iseTrailer = lastSegment;
        } else {
            this.throwParserException("IEA", currentSegmentId);
        }
        while (segments.hasNext()) {
            List<TransactionHolder> transactionsInGroup = this.doGroup(segments);
            transactionHolders.addAll(transactionsInGroup);
            if (segments.hasNext()) {
                currentSegment = segments.next();
                currentSegmentId = currentSegment.getIdentifier();
                if ("IEA".equals(currentSegmentId)) break;
                segments.previous();
                continue;
            }
            this.throwParserExceptionUnexpectedEnd(currentSegmentId);
        }
        this.populateIsaEnvelope(isaHeader, iseTrailer, transactionHolders);
        return transactionHolders;
    }

    private void populateIsaEnvelope(X12Segment isaHeader, X12Segment iseTrailer, List<TransactionHolder> transactionHolders) {
        this.alterEnvelopeTrailerBasedOnSplit(iseTrailer);
        transactionHolders.forEach(txHolder -> {
            txHolder.setIsaHeader(isaHeader);
            txHolder.setIseTrailer(iseTrailer);
        });
    }

    private List<TransactionHolder> doGroup(SegmentIterator segments) {
        ArrayList<TransactionHolder> transactionsInGroup = new ArrayList<TransactionHolder>();
        X12Segment groupHeader = null;
        X12Segment currentSegment = segments.next();
        String currentSegmentId = currentSegment.getIdentifier();
        if ("GS".equals(currentSegmentId)) {
            groupHeader = currentSegment;
            while (segments.hasNext()) {
                TransactionHolder transactionHolder = this.doTransaction(segments);
                transactionHolder.setGsHeader(groupHeader);
                transactionsInGroup.add(transactionHolder);
                if (segments.hasNext()) {
                    currentSegment = segments.next();
                    currentSegmentId = currentSegment.getIdentifier();
                    if ("GE".equals(currentSegmentId)) {
                        X12Segment groupTrailer = currentSegment;
                        this.alterGroupTrailerBasedOnSplit(groupTrailer);
                        transactionsInGroup.forEach(txHolder -> txHolder.setGeTrailer(groupTrailer));
                        break;
                    }
                    segments.previous();
                    continue;
                }
                this.throwParserExceptionUnexpectedEnd(currentSegmentId);
            }
        } else {
            this.throwParserException("GS", currentSegmentId);
        }
        return transactionsInGroup;
    }

    protected void alterGroupTrailerBasedOnSplit(X12Segment groupTrailer) {
    }

    protected void alterEnvelopeTrailerBasedOnSplit(X12Segment envelopeTrailer) {
    }

    private TransactionHolder doTransaction(SegmentIterator segments) {
        TransactionHolder transactionHolder = new TransactionHolder();
        X12Segment currentSegment = segments.next();
        String currentSegmentId = currentSegment.getIdentifier();
        if ("ST".equals(currentSegmentId)) {
            transactionHolder.addSegmentToTransaction(currentSegment);
            while (segments.hasNext() && !"SE".equals(currentSegmentId)) {
                currentSegment = segments.next();
                currentSegmentId = currentSegment.getIdentifier();
                transactionHolder.addSegmentToTransaction(currentSegment);
            }
        } else {
            this.throwParserException("ST", currentSegmentId);
        }
        if (!"SE".equals(currentSegmentId)) {
            this.throwParserException("SE", currentSegmentId);
        }
        return transactionHolder;
    }

    private List<String> doSplit(List<TransactionHolder> transactionHolders) {
        ArrayList<String> transactions = new ArrayList<String>();
        transactionHolders.forEach(transaction -> {
            StringBuilder sb = new StringBuilder();
            sb.append(transaction.getIsaHeader().toString()).append(EOL);
            sb.append(transaction.getGsHeader().toString()).append(EOL);
            transaction.getTransaction().forEach(txSegment -> sb.append(txSegment.toString()).append(EOL));
            sb.append(transaction.getGeTrailer().toString()).append(EOL);
            sb.append(transaction.getIseTrailer().toString());
            transactions.add(sb.toString());
        });
        return transactions;
    }

    private void runRules(List<X12Segment> segmentList) {
        if (this.rules != null) {
            this.rules.forEach(rule -> {
                if (rule != null) {
                    rule.verify(segmentList);
                }
            });
        }
    }

    private void throwParserException(String expectedSegmentId, String actualSegmentId) {
        StringBuilder sb = new StringBuilder();
        sb.append("expected ").append(expectedSegmentId);
        sb.append(" segment but got ").append(actualSegmentId);
        throw new X12ParserException(new X12ErrorDetail(expectedSegmentId, "", sb.toString()));
    }

    private void throwParserExceptionUnexpectedEnd(String actualSegmentId) {
        StringBuilder sb = new StringBuilder();
        sb.append("unexpectedly ran out of segments - last segment id (").append(actualSegmentId).append(")");
        throw new X12ParserException(new X12ErrorDetail("", "", sb.toString()));
    }

    public X12TransactionSplitter() {
    }

    public X12TransactionSplitter(List<X12Rule> rules) {
        this.rules = rules;
    }

    public class TransactionHolder {
        private X12Segment isaHeader;
        private X12Segment iseTrailer;
        private X12Segment gsHeader;
        private X12Segment geTrailer;
        private List<X12Segment> transactionSegmentList;

        public X12Segment getIsaHeader() {
            return this.isaHeader;
        }

        public void setIsaHeader(X12Segment isaHeader) {
            this.isaHeader = isaHeader;
        }

        public X12Segment getIseTrailer() {
            return this.iseTrailer;
        }

        public void setIseTrailer(X12Segment iseTrailer) {
            this.iseTrailer = iseTrailer;
        }

        public X12Segment getGsHeader() {
            return this.gsHeader;
        }

        public void setGsHeader(X12Segment gsHeader) {
            this.gsHeader = gsHeader;
        }

        public X12Segment getGeTrailer() {
            return this.geTrailer;
        }

        public void setGeTrailer(X12Segment geTrailer) {
            this.geTrailer = geTrailer;
        }

        public List<X12Segment> getTransaction() {
            return this.transactionSegmentList;
        }

        public void setTransaction(List<X12Segment> transaction) {
            this.transactionSegmentList = transaction;
        }

        public void addSegmentToTransaction(X12Segment segment) {
            if (this.transactionSegmentList == null) {
                this.transactionSegmentList = new ArrayList<X12Segment>();
            }
            this.transactionSegmentList.add(segment);
        }
    }
}

