/*
 * Decompiled with CFR 0.152.
 */
package com.washingtonpost.dw.auth;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.cache.CacheBuilderSpec;
import com.washingtonpost.dw.auth.AllowedPeerAuthenticator;
import com.washingtonpost.dw.auth.dao.FlatFilePeerDAO;
import com.washingtonpost.dw.auth.dao.StringPeerDAO;
import com.washingtonpost.dw.auth.model.Peer;
import io.dropwizard.auth.AuthFactory;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.CachingAuthenticator;
import io.dropwizard.auth.basic.BasicAuthFactory;
import io.dropwizard.auth.basic.BasicCredentials;
import io.dropwizard.setup.Environment;
import java.io.InputStream;
import jersey.repackaged.com.google.common.base.Preconditions;

public class AllowedPeerConfiguration {
    private String realm = "peers";
    private CacheBuilderSpec cachePolicy;
    private String credentialFile;
    private String users;
    private String passwords;
    private String delimiter = ";";

    @JsonProperty(value="realm")
    public String getRealm() {
        return this.realm;
    }

    @JsonProperty(value="realm")
    public void setRealm(String realm) {
        this.realm = realm;
    }

    @JsonProperty(value="credentialFile")
    public String getCredentialFile() {
        return this.credentialFile;
    }

    @JsonProperty(value="credentialFile")
    public void setCredentialFile(String credentialFile) {
        this.credentialFile = credentialFile;
    }

    @JsonProperty(value="cachePolicy")
    public CacheBuilderSpec getCachePolicy() {
        return this.cachePolicy;
    }

    @JsonProperty(value="cachePolicy")
    public void setCachePolicy(CacheBuilderSpec cachePolicy) {
        this.cachePolicy = cachePolicy;
    }

    @JsonProperty(value="users")
    public String getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    public void setUsers(String users) {
        this.users = users;
    }

    @JsonProperty(value="passwords")
    public String getPasswords() {
        return this.passwords;
    }

    @JsonProperty(value="passwords")
    public void setPasswords(String passwords) {
        this.passwords = passwords;
    }

    @JsonProperty(value="delimiter")
    public String getDelimiter() {
        return this.delimiter;
    }

    @JsonProperty(value="delimiter")
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Authenticator<BasicCredentials, Peer> createAuthenticator() {
        if (this.credentialFile != null) {
            InputStream allowedPeersResource = this.getClass().getClassLoader().getResourceAsStream(this.credentialFile);
            return new AllowedPeerAuthenticator(new FlatFilePeerDAO(allowedPeersResource));
        }
        if (this.users != null && this.passwords != null && this.delimiter != null) {
            return new AllowedPeerAuthenticator(new StringPeerDAO(this.users, this.passwords, this.delimiter));
        }
        throw new IllegalStateException("Illegal call to createAuthenticator() when no valid configuration was set");
    }

    public CachingAuthenticator<BasicCredentials, Peer> createCachingAuthenticator(MetricRegistry metrics) {
        Preconditions.checkNotNull((Object)this.cachePolicy, (Object)"Illegal call to createCachingAuthenticator() when the configuration object's cachePolicy attribute is null");
        return new CachingAuthenticator(metrics, this.createAuthenticator(), this.cachePolicy);
    }

    public void registerAuthenticator(Environment environment) {
        Preconditions.checkNotNull((Object)environment, (Object)"Illegal call to registerAuthenticator with a null Environment object");
        Object authenticator = this.cachePolicy != null ? this.createCachingAuthenticator(environment.metrics()) : this.createAuthenticator();
        environment.jersey().register((Object)AuthFactory.binder((AuthFactory)new BasicAuthFactory(authenticator, this.realm, Peer.class)));
    }
}

