/*
 * Decompiled with CFR 0.152.
 */
package com.washingtonpost.dw.auth.dao;

import com.google.common.collect.Sets;
import com.washingtonpost.dw.auth.dao.PeerDAO;
import com.washingtonpost.dw.auth.model.Peer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFilePeerDAO
implements PeerDAO {
    private static final Logger logger = LoggerFactory.getLogger(FlatFilePeerDAO.class);
    private final Properties allowedPeers = new Properties();

    public FlatFilePeerDAO(InputStream inputStream) {
        try {
            this.allowedPeers.load(inputStream);
            inputStream.close();
        }
        catch (IOException ioe) {
            logger.error("Could not load allowed peers into a Properties object", (Throwable)ioe);
            throw new RuntimeException("This application requires a classpath-accessible file configured under the allowedPeers.credentialFile property to load the allowed requestors of this service.  No such file could be loaded.", ioe);
        }
    }

    @Override
    public Collection<Peer> findAll() {
        LinkedHashSet peers = Sets.newLinkedHashSetWithExpectedSize((int)this.allowedPeers.size());
        this.allowedPeers.entrySet().stream().forEach(entrySet -> peers.add(new Peer((String)entrySet.getKey(), (String)entrySet.getValue())));
        return peers;
    }
}

