/*
 * Decompiled with CFR 0.152.
 */
package com.washingtonpost.dw.auth.dao;

import com.washingtonpost.dw.auth.dao.PeerDAO;
import com.washingtonpost.dw.auth.model.Peer;
import java.util.Collection;
import java.util.HashSet;
import jersey.repackaged.com.google.common.base.Preconditions;

public class StringPeerDAO
implements PeerDAO {
    public static final String DEFAULT_DELIMITER = ";";
    private final Collection<Peer> peers;

    public StringPeerDAO(String users, String passwords, String delimiter) {
        Preconditions.checkNotNull((Object)users, (Object)"String containing users must not be null");
        Preconditions.checkNotNull((Object)passwords, (Object)"String containing passwords must not be null");
        Preconditions.checkNotNull((Object)delimiter, (Object)"Delimiter String must not be null");
        String[] userArray = users.split(delimiter);
        String[] passArray = passwords.split(delimiter);
        Preconditions.checkState((userArray.length == passArray.length ? 1 : 0) != 0, (Object)("Length of users (" + userArray.length + ") must match " + "the length of the passwords (" + passArray.length + ")"));
        this.peers = new HashSet<Peer>();
        for (int i = 0; i < userArray.length; ++i) {
            this.peers.add(new Peer(userArray[i], passArray[i]));
            System.out.println("Added peer " + userArray[i] + " with password " + passArray[i]);
        }
    }

    public StringPeerDAO(String users, String passwords) {
        this(users, passwords, DEFAULT_DELIMITER);
    }

    @Override
    public Collection<Peer> findAll() {
        return this.peers;
    }
}

