/*
 * Decompiled with CFR 0.152.
 */
package com.washingtonpost.dropwizard.exceptions.mappers;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.dropwizard.jersey.errors.ErrorMessage;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JsonProcessingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonProcessingExceptionMapper.class);
    private static final boolean DEFAULT_SHOW_DETAILS = true;
    private static final MediaType DEFAULT_MEDIA_TYPE = MediaType.APPLICATION_JSON_TYPE;
    private final boolean showDetails;
    private final MediaType mediaType;

    public JsonProcessingExceptionMapper() {
        this(true, DEFAULT_MEDIA_TYPE);
    }

    public JsonProcessingExceptionMapper(boolean showDetails, MediaType mediaType) {
        this.showDetails = showDetails;
        this.mediaType = mediaType;
    }

    public Response toResponse(JsonProcessingException exception) {
        if (exception instanceof JsonGenerationException) {
            LOGGER.warn("Error generating JSON", (Throwable)exception);
            return Response.serverError().type(this.mediaType).entity((Object)new ErrorMessage(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Error generating JSON", this.showDetails ? exception.getOriginalMessage() : null)).build();
        }
        String message = exception.getOriginalMessage();
        if (message.startsWith("No suitable constructor found")) {
            LOGGER.error("Unable to deserialize the specific type", (Throwable)exception);
            return Response.serverError().type(this.mediaType).entity((Object)new ErrorMessage(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Unable to deserialize the specific type", this.showDetails ? exception.getOriginalMessage() : null)).build();
        }
        LOGGER.debug("Unable to process JSON", (Throwable)exception);
        ErrorMessage errorMessage = new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to process JSON", this.showDetails ? message : null);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(this.mediaType).entity((Object)errorMessage).build();
    }
}

