/*
 * Decompiled with CFR 0.152.
 */
package com.washingtonpost.dropwizard.exceptions.mappers;

import io.dropwizard.jersey.errors.ErrorMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeExceptionMapper.class);
    private static final boolean DEFAULT_SHOW_DETAILS = false;
    private static final MediaType DEFAUT_MEDIA_TYPE = MediaType.APPLICATION_JSON_TYPE;
    private final boolean showDetails;
    private final MediaType mediaType;

    public RuntimeExceptionMapper() {
        this(false, DEFAUT_MEDIA_TYPE);
    }

    public RuntimeExceptionMapper(boolean showDetails, MediaType mediaType) {
        this.showDetails = showDetails;
        this.mediaType = mediaType;
    }

    public Response toResponse(RuntimeException exception) {
        Response defaultResponse = Response.serverError().type(this.mediaType).entity((Object)new ErrorMessage(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), exception.getMessage(), this.showDetails ? this.stackTraceToString(exception) : null)).build();
        if (exception instanceof WebApplicationException) {
            LOGGER.info("Using specific handler");
            return this.handleWebApplicationException(exception, defaultResponse);
        }
        LOGGER.error(exception.getMessage(), (Throwable)exception);
        return defaultResponse;
    }

    private Response handleWebApplicationException(RuntimeException exception, Response defaultResponse) {
        WebApplicationException webAppException = (WebApplicationException)exception;
        if (webAppException.getResponse().getStatus() == 401) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(this.mediaType).entity((Object)new ErrorMessage(Response.Status.UNAUTHORIZED.getStatusCode(), exception.getMessage(), this.showDetails ? this.stackTraceToString(exception) : null)).build();
        }
        if (webAppException.getResponse().getStatus() == 403) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type(this.mediaType).entity((Object)new ErrorMessage(Response.Status.FORBIDDEN.getStatusCode(), exception.getMessage(), this.showDetails ? this.stackTraceToString(exception) : null)).build();
        }
        if (webAppException.getResponse().getStatus() == 404) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type(this.mediaType).entity((Object)new ErrorMessage(Response.Status.NOT_FOUND.getStatusCode(), exception.getMessage(), this.showDetails ? this.stackTraceToString(exception) : null)).build();
        }
        LOGGER.error(exception.getMessage(), (Throwable)exception);
        Response r = Response.status((int)webAppException.getResponse().getStatus()).type(this.mediaType).entity((Object)new ErrorMessage(webAppException.getResponse().getStatus(), exception.getMessage(), this.showDetails ? this.stackTraceToString(exception) : null)).build();
        return r;
    }

    private String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

