/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.framework.utils;

import java.io.IOException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class StringUtils {
    private static MessageDigest digest = null;

    public static int compareString(String s, String s1, String s2) {
        int j;
        int i;
        if (s1 == null) {
            return s == null ? 0 : 1;
        }
        if (s == null) {
            return -1;
        }
        try {
            byte[] abyte0 = s.getBytes(s2);
            byte[] abyte1 = s1.getBytes(s2);
            i = abyte0.length;
            j = abyte1.length;
            int k = Math.min(i, j);
            int i1 = k;
            for (int l = 0; l < i1; ++l) {
                int j1 = abyte0[l] & 0xFF;
                int k1 = abyte1[l] & 0xFF;
                if (j1 == k1) continue;
                return j1 - k1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return i - j;
    }

    public static String encodePassword(String password, String algorithm) {
        byte[] unencodedPassword = password.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            return password;
        }
        md.reset();
        md.update(unencodedPassword);
        byte[] encodedPassword = md.digest();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < encodedPassword.length; ++i) {
            if ((encodedPassword[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(encodedPassword[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static String encodeString(String str) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encodeBuffer(str.getBytes()).trim();
    }

    public static String decodeString(String str) {
        BASE64Decoder dec = new BASE64Decoder();
        try {
            return new String(dec.decodeBuffer(str));
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io.getCause());
        }
    }

    public static boolean strEquals(String s, String s1) {
        if (s != null && s1 != null) {
            return s.equals(s1);
        }
        return s == s1;
    }

    public static String join(Object[] aobj, String s) {
        return StringUtils.join(Arrays.asList(aobj).iterator(), s);
    }

    public static String join(Iterator iterator, String s) {
        StringBuffer stringbuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringbuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringbuffer.append(s);
        }
        return stringbuffer.toString();
    }

    public static synchronized String formatChineseString(String s) {
        String s1 = s;
        if (s1 == null) {
            return s1;
        }
        s1 = StringUtils.replace(s1, "\uff10", "0");
        s1 = StringUtils.replace(s1, "\uff11", "1");
        s1 = StringUtils.replace(s1, "\uff12", "2");
        s1 = StringUtils.replace(s1, "\uff13", "3");
        s1 = StringUtils.replace(s1, "\uff14", "4");
        s1 = StringUtils.replace(s1, "\uff15", "5");
        s1 = StringUtils.replace(s1, "\uff16", "6");
        s1 = StringUtils.replace(s1, "\uff17", "7");
        s1 = StringUtils.replace(s1, "\uff18", "8");
        s1 = StringUtils.replace(s1, "\uff19", "9");
        s1 = StringUtils.replace(s1, "\uff03", "#");
        return s1;
    }

    public static String trimToByteSize(String s, String s1, int i) {
        if (s != null) {
            int j = 0;
            int byte0 = 2;
            int k = s.length();
            if (s1.charAt(0) == 'U') {
                byte0 = 3;
            }
            for (int l = 0; l < k; ++l) {
                if (j > i) {
                    return s.substring(0, l - 1);
                }
                if ((s.charAt(l) & 0xFFFFFF00) != 0) {
                    j += byte0;
                    continue;
                }
                ++j;
            }
        }
        return s;
    }

    public static boolean objectEquals(Object obj, Object obj1) {
        if (obj != null && obj1 != null) {
            return obj.equals(obj1);
        }
        return obj == null && obj1 == null;
    }

    public static String merge(String[] src, String delimiter) {
        StringBuffer newSrc = new StringBuffer();
        for (int i = 0; i < src.length; ++i) {
            if (i < src.length - 1) {
                newSrc.append(src[i]).append(delimiter);
                continue;
            }
            newSrc.append(src[i]);
        }
        return newSrc.toString();
    }

    public static String defaultString(String ab) {
        return ab;
    }

    public static String[] split(String ext) {
        return StringUtils.split(ext, ',');
    }

    public static String[] split(String ext, char pix) {
        return ext.split(String.valueOf(pix));
    }

    public static boolean isNullOrBank(String ext) {
        return ext == null || ext.equals("");
    }

    public static boolean isEmpty(String ext) {
        return StringUtils.isNullOrBank(ext);
    }

    public static String[] split(String str, int sect, int len) throws Exception {
        String[] result = new String[sect];
        int j = 0;
        for (j = 0; j < sect; ++j) {
            result[j] = "";
        }
        for (j = 0; j < sect && str.length() >= len * j; ++j) {
            result[j] = str.length() < len * (j + 1) ? str.substring(len * j, str.length()) : str.substring(len * j, len * (j + 1));
        }
        return result;
    }

    public static String URLEncode(String srcStr, String encoding) {
        String[] arrayUrl = srcStr.split("?");
        if (arrayUrl.length <= 1) {
            return srcStr;
        }
        String qryStr = arrayUrl[1];
        String[] arrayQryStr = qryStr.split("&");
        StringBuffer newQryStr = new StringBuffer(120);
        StringBuffer tmp = new StringBuffer(20);
        for (int i = 0; i < arrayQryStr.length; ++i) {
            String param = arrayQryStr[i];
            String[] arrayParam = param.split("=");
            if (arrayParam.length > 1) {
                try {
                    arrayParam[1] = URLEncoder.encode(arrayParam[1], encoding);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tmp.append(arrayParam[0]).append("=").append(arrayParam[1]);
                arrayQryStr[i] = tmp.toString();
            } else {
                tmp.append(arrayParam[0]).append("=");
                arrayQryStr[i] = tmp.toString();
            }
            newQryStr.append(arrayQryStr[i]).append("&");
        }
        tmp = new StringBuffer(150);
        tmp.append(arrayUrl[0]).append("?").append(newQryStr.toString());
        return tmp.toString();
    }

    public static final String replace(String line, String oldString, String newString) {
        if (line == null) {
            return null;
        }
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static final String replace(String line, String oldString, String newString, int[] count) {
        if (line == null) {
            return null;
        }
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            int counter = 0;
            ++counter;
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                ++counter;
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            count[0] = counter;
            return buf.toString();
        }
        return line;
    }

    public static final String replaceIgnoreCase(String line, String oldString, String newString) {
        if (line == null) {
            return null;
        }
        String lcLine = line.toLowerCase();
        String lcOldString = oldString.toLowerCase();
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static int getStrIndex(String s, String[] args) {
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            if (!args[i].equals(s)) continue;
            return i;
        }
        return -1;
    }

    public static String nullToEmpty(String src) {
        if (src == null || src.equalsIgnoreCase("NULL")) {
            return "";
        }
        return src;
    }

    public static String toCamelCasing(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < s.length() - 1; ++i) {
            char ch = s.charAt(i);
            if (ch != '_') {
                buffer.append(ch);
                continue;
            }
            char nextChar = s.charAt(i + 1);
            if (nextChar == '_') continue;
            if (buffer.toString().length() < 2) {
                buffer.append(Character.toLowerCase(nextChar));
            } else {
                buffer.append(Character.toUpperCase(nextChar));
            }
            ++i;
        }
        char lastChar = s.charAt(s.length() - 1);
        if (lastChar != '_') {
            buffer.append(lastChar);
        }
        return buffer.toString();
    }

    public static String lowerFirstChar(String s) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Character.toLowerCase(s.charAt(0))).append(s.substring(1));
        return buffer.toString();
    }

    public static String upperFirstChar(String s) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1));
        return buffer.toString();
    }
}

