/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone;

import com.aiyc.framework.monitor.DaoMonitor;
import com.aiyc.framework.monitor.SessionManager;
import com.aiyc.server.standalone.dzdp.NotifyEnterPlace;
import com.aiyc.server.standalone.longwait.AloneServer;
import com.aiyc.server.standalone.net.CalcTasker;
import com.aiyc.server.standalone.net.ConnectionHandler;
import com.aiyc.server.standalone.svm.TrainSVMTimerTask;
import com.aiyc.server.standalone.util.Configuration;
import com.aiyc.server.standalone.util.ConsoleData;
import com.aiyc.server.standalone.util.Log;
import com.waspring.wasdbtools.DatabaseConnection;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WasStandaloneServer
implements Runnable {
    private final ServerSocket serverSocket;
    private final ExecutorService threadPool;
    private static Logger log;
    private boolean running;
    private static URLClassLoader calcLoader;
    private static URLClassLoader serviceLoader;

    public static void main(String[] args) {
        WasStandaloneServer.initConfig(args);
        WasStandaloneServer.startServer();
    }

    public WasStandaloneServer(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        System.out.println("HTTP SERVER SERVICE...PORT:" + port);
        this.threadPool = Executors.newCachedThreadPool();
        log = Log.getLogger();
    }

    public static void initConfig(String[] args) {
        System.out.println(new File("database.xml").getAbsolutePath());
        DatabaseConnection.setConnConfig((String)"database.xml");
        Object list = ConsoleData.instance().getCachedValue("hander");
        if (args.length > 0) {
            Configuration.ServerPort = new Integer(args[0]);
        }
        WasStandaloneServer.getServiceClassLoader();
        WasStandaloneServer.getCalcClassLoader();
    }

    public static URLClassLoader getServiceClassLoader() {
        if (serviceLoader == null) {
            File cl = new File(Configuration.hander_indoor_libdir);
            URL indoor = null;
            try {
                indoor = cl.toURL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            serviceLoader = new URLClassLoader(new URL[]{indoor}, Thread.currentThread().getContextClassLoader());
        }
        return serviceLoader;
    }

    public static URLClassLoader getCalcClassLoader() {
        if (calcLoader == null) {
            File cl = new File(Configuration.calc_indoor_libdir);
            URL indoor = null;
            try {
                indoor = cl.toURL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            calcLoader = new URLClassLoader(new URL[]{indoor}, Thread.currentThread().getContextClassLoader());
        }
        return calcLoader;
    }

    public static void startClac() throws Exception {
        if (Configuration.calcSort == 2 || Configuration.calcSort == 3) {
            System.out.println("geo calc  start ....");
            Class<?> task = calcLoader.loadClass(Configuration.calc_indoor_path);
            CalcTasker calc = (CalcTasker)task.newInstance();
            calc.start();
        }
        if (Configuration.calcSort == 1 || Configuration.calcSort == 3) {
            System.out.println("wifi calc  start ....");
            TrainSVMTimerTask.start();
        }
    }

    public static void startServer() {
        try {
            WasStandaloneServer server = new WasStandaloneServer(Configuration.ServerPort);
            new Thread(server).start();
            AloneServer server2 = AloneServer.instance();
            server2.start();
            System.out.println("SOKECT SERVER SERVICE...PORT:" + Configuration.LongServerPort);
            NotifyEnterPlace.instance().start();
            System.out.println("Notify SERVICE start.....");
            try {
                WasStandaloneServer.startClac();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SessionManager.instance().listener();
            System.out.println("Session service start.....");
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Failed to start server", e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info("Started server at " + this.serverSocket.getInetAddress().getHostName() + ":" + this.serverSocket.getLocalPort());
        this.running = true;
        try {
            while (this.running) {
                this.threadPool.execute(new ConnectionHandler(this.serverSocket.accept()));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            if (this.running) {
                log.log(Level.SEVERE, "caught io execpton: " + ex.getMessage(), ex);
            }
            log.fine(ex.getMessage());
        }
        this.threadPool.shutdown();
        log.fine("Shutting down thread pool...");
        while (!this.threadPool.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        log.fine("Thread pool shut down");
        WasStandaloneServer wasStandaloneServer = this;
        synchronized (wasStandaloneServer) {
            this.notifyAll();
        }
        NotifyEnterPlace.instance().destory();
        System.out.println("Stopped server at " + this.serverSocket.getInetAddress().getHostName() + ":" + this.serverSocket.getLocalPort());
    }

    public void stopServer() {
        log.info("Stopping server...");
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        calcLoader = null;
        serviceLoader = null;
    }

    public class ShutdownHandler
    implements Runnable {
        WasStandaloneServer server = null;
        DaoMonitor dm = null;

        public ShutdownHandler(WasStandaloneServer server, DaoMonitor dm) {
            this.server = server;
            this.dm = dm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.fine("Control-C caught. Shutting down gracefully...");
            this.server.stopServer();
            try {
                WasStandaloneServer wasStandaloneServer = this.server;
                synchronized (wasStandaloneServer) {
                    log.info("Waiting for server shutdown...");
                    this.server.wait();
                    log.info("Server shut down, now quitting...");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

