/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.db.homes;

import com.aiyc.server.standalone.core.measure.BluetoothReading;
import com.aiyc.server.standalone.db.homes.EntityHome;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothReadingHome
extends EntityHome<BluetoothReading> {
    private static final String[] TableCols = new String[]{"friendlyName", "bluetoothAddress", "majorDeviceClass", "minorDeviceClass"};
    private static final String TableName = "bluetoothreading";
    private static final String TableIdCol = "bluetoothReadingId";

    @Override
    protected String getTableName() {
        return TableName;
    }

    @Override
    protected String getTableIdCol() {
        return TableIdCol;
    }

    @Override
    protected String[] getTableCols() {
        return TableCols;
    }

    @Override
    public BluetoothReading parseResultRow(ResultSet rs, int fromIndex) throws SQLException {
        BluetoothReading reading = new BluetoothReading();
        try {
            reading.setId(rs.getInt(fromIndex));
            reading.setFriendlyName(rs.getString(fromIndex + 1));
            reading.setBluetoothAddress(rs.getString(fromIndex + 2));
            reading.setMajorDeviceClass(rs.getString(fromIndex + 3));
            reading.setMinorDeviceClass(rs.getString(fromIndex + 4));
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "parseResultRow failed: " + e.getMessage(), e);
            throw e;
        }
        return reading;
    }

    @Override
    public int fillInStatement(PreparedStatement ps, BluetoothReading t, int fromIndex) throws SQLException {
        return this.fillInStatement(ps, new Object[]{t.getFriendlyName(), t.getBluetoothAddress(), t.getMajorDeviceClass(), t.getMinorDeviceClass()}, new int[]{12, 12, 12, 12}, fromIndex);
    }
}

