/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.db.homes;

import com.aiyc.server.standalone.db.IEntity;
import com.aiyc.server.standalone.db.homes.IArea;
import com.aiyc.server.standalone.db.homes.IEntityHome;
import com.aiyc.server.standalone.util.Configuration;
import com.aiyc.server.standalone.util.ConsoleData;
import com.aiyc.server.standalone.util.Log;
import com.waspring.wasdbtools.DatabaseConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityHome<T extends IEntity<Integer>>
implements IEntityHome<T, Integer>,
IArea {
    protected String area = "";
    protected int primaryKeyId = -1;
    protected DatabaseConnection db;
    protected Logger log;
    protected String TableColNames = null;
    protected String insertSQL = null;
    protected String updateSQL = null;
    protected String selectSQL = null;
    protected String deleteSQL = null;

    @Override
    public String getArea() {
        return this.area;
    }

    @Override
    public void setArea(String area) {
        this.area = area;
        if (area == null) {
            this.area = "";
        }
    }

    public EntityHome() {
        this.setArea((String)ConsoleData.instance().getCachedValue("area"));
        this.db = DatabaseConnection.getInstance();
        this.log = Log.getLogger();
    }

    protected abstract String getTableName();

    protected String getTableColNames() {
        if (this.TableColNames == null) {
            this.TableColNames = this.getTableName() + "." + this.getTableIdCol();
            for (String colName : this.getTableCols()) {
                this.TableColNames = this.TableColNames + ", " + this.getTableName() + "." + colName;
            }
        }
        return this.TableColNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int getPrimaryKeyId() {
        if (this.primaryKeyId == -1) {
            ResultSet rs = null;
            Statement stat = null;
            try {
                EntityHome entityHome = this;
                stat = entityHome.db.getConnection().createStatement();
                rs = stat.executeQuery("SELECT MAX(" + this.getTableIdCol() + ") FROM " + this.getTableName());
                this.primaryKeyId = rs.next() ? rs.getInt(1) : 0;
            }
            catch (SQLException e) {
                this.primaryKeyId = -1;
                this.log.log(Level.SEVERE, "getPrimaryKeyId failed: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stat != null) {
                        stat.close();
                    }
                }
                catch (SQLException es) {
                    this.log.log(Level.WARNING, "failed to close db resources: " + es.getMessage(), es);
                }
            }
        }
        ++this.primaryKeyId;
        return this.primaryKeyId;
    }

    protected String getInsertSQL() {
        if (this.insertSQL == null) {
            this.insertSQL = " INSERT INTO " + this.getTableName() + " (" + this.getTableIdCol() + ", " + EntityHome.implode(this.getTableCols()) + ") VALUES (? " + this.repeat(",?", this.getTableCols().length) + ");";
        }
        return this.insertSQL;
    }

    protected String getUpdateSQL() {
        if (this.updateSQL == null) {
            String[] cols = this.getTableCols();
            this.updateSQL = " UPDATE " + this.getTableName() + " SET ";
            boolean first = true;
            for (int i = 0; i < this.getTableCols().length; ++i) {
                if (!first) {
                    this.updateSQL = this.updateSQL + " , ";
                }
                this.updateSQL = this.updateSQL + cols[i] + " = ?";
                first = false;
            }
            this.updateSQL = this.updateSQL + " WHERE " + this.getTableIdCol() + " = ? ;";
        }
        return this.updateSQL;
    }

    protected String getSelectSQL() {
        if (this.selectSQL == null) {
            this.selectSQL = "SELECT " + this.getTableColNames() + " FROM " + this.getTableName();
        }
        return this.selectSQL;
    }

    protected String getOrder() {
        return "";
    }

    protected String getDeleteSQL() {
        if (this.deleteSQL == null) {
            this.deleteSQL = "DELETE FROM " + this.getTableName();
        }
        return this.deleteSQL;
    }

    protected abstract String getTableIdCol();

    protected abstract String[] getTableCols();

    protected T parseResultRow(ResultSet rs) throws SQLException {
        return this.parseResultRow(rs, 1);
    }

    public abstract T parseResultRow(ResultSet var1, int var2) throws SQLException;

    protected int fillInStatement(PreparedStatement ps, Object[] values, int[] sqlTypes) throws SQLException {
        return this.fillInStatement(ps, values, sqlTypes, 1);
    }

    protected int fillInStatement(PreparedStatement ps, Object[] values, int[] sqlTypes, int fromIndex) throws SQLException {
        for (int i = 0; i < values.length; ++i) {
            ps.setObject(fromIndex + i, values[i], sqlTypes[i]);
        }
        return values.length;
    }

    protected int fillInStatement(PreparedStatement ps, T e) throws SQLException {
        return this.fillInStatement(ps, e, 1);
    }

    protected abstract int fillInStatement(PreparedStatement var1, T var2, int var3) throws SQLException;

    public int executeInsertUpdate(Vector<PreparedStatement> vps, T e) throws SQLException {
        int id = this.getPrimaryKeyId();
        PreparedStatement ps = this.getPreparedStatement(this.getInsertSQL());
        ps.setInt(1, id);
        this.fillInStatement(ps, e, 2);
        vps.add(ps);
        ps.executeUpdate();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T add(T e) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.getPreparedStatement(this.getInsertSQL());
            e.setId(this.getPrimaryKeyId());
            ps.setInt(1, (Integer)e.getId());
            this.fillInStatement(ps, e, 2);
            ps.executeUpdate();
            rs = this.getGeneratedKey(ps);
            if (rs != null && rs.next()) {
                e.setId(rs.getInt(1));
            }
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "add failed: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close db resources: " + es.getMessage(), es);
            }
        }
        return e;
    }

    @Override
    public List<T> add(List<T> list) {
        IEntity e;
        IEntity el;
        ArrayList<IEntity> res = new ArrayList<IEntity>(list.size());
        Iterator<T> i$ = list.iterator();
        while (i$.hasNext() && (el = this.add((T)(e = (IEntity)i$.next()))) != null) {
            res.add(el);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized List<T> get(String constraint) {
        String order;
        ArrayList<T> res = new ArrayList<T>();
        String sql = this.getSelectSQL();
        if (constraint != null && constraint.length() > 0) {
            sql = sql + " WHERE " + constraint;
        }
        if ((order = this.getOrder()) != null && order.length() > 0) {
            sql = sql + " ORDER BY " + order;
        }
        this.log.finest(sql);
        ResultSet rs = null;
        Statement stat = null;
        try {
            EntityHome entityHome = this;
            stat = entityHome.db.getConnection().createStatement();
            rs = stat.executeQuery(sql);
            while (rs.next()) {
                res.add(this.parseResultRow(rs));
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "get failed: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close ResultSet: " + es.getMessage(), es);
            }
        }
        return res;
    }

    @Override
    public T get(T e) {
        if (e == null || e.getId() == null || (Integer)e.getId() == -1) {
            return null;
        }
        return this.getById((Integer)e.getId());
    }

    @Override
    public T getById(Integer id) {
        if (id == null || id == -1) {
            return null;
        }
        String constraint = this.getTableIdCol() + " = " + id;
        String list = this.get((T)constraint);
        if (list.size() == 0) {
            return null;
        }
        return (T)((IEntity)list.get(0));
    }

    public T getByName(String name) {
        String constraint = " symbolicId= '" + name + "'";
        String list = this.get((T)constraint);
        if (list.size() == 0) {
            return null;
        }
        return (T)((IEntity)list.get(0));
    }

    @Override
    public List<T> get(List<T> list) {
        if (list == null) {
            return new ArrayList();
        }
        ArrayList<Integer> ids = new ArrayList<Integer>(list.size());
        for (IEntity entity : list) {
            if (entity.getId() == null || (Integer)entity.getId() == -1) continue;
            ids.add((Integer)entity.getId());
        }
        if (ids.isEmpty()) {
            return new ArrayList();
        }
        return this.getById((List<Integer>)ids);
    }

    @Override
    public List<T> getById(List<Integer> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList();
        }
        String constraint = this.getTableIdCol() + " IN  (" + EntityHome.implode(ids.toArray()) + ")";
        return this.get((T)constraint);
    }

    @Override
    public List<T> getAll() {
        return this.get((T)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean remove(String constraint) {
        String sql = this.getDeleteSQL();
        if (constraint != null && constraint.length() > 0) {
            sql = sql + " WHERE " + constraint;
        }
        this.log.finest(sql);
        Statement stat = null;
        try {
            int res = -1;
            EntityHome entityHome = this;
            stat = entityHome.db.getConnection().createStatement();
            res = stat.executeUpdate(sql);
            boolean bl = res > 0;
            return bl;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "remove failed: " + e.getMessage(), e);
        }
        finally {
            try {
                EntityHome entityHome = this;
                entityHome.db.getConnection().setAutoCommit(true);
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
            }
        }
        return false;
    }

    @Override
    public boolean remove(T e) {
        if (e == null || e.getId() == null || (Integer)e.getId() == -1) {
            return true;
        }
        String constraint = this.getTableIdCol() + " = " + e.getId();
        return this.remove(constraint);
    }

    @Override
    public boolean remove(List<T> list) {
        if (list == null) {
            return true;
        }
        ArrayList ids = new ArrayList(list.size());
        for (IEntity entity : list) {
            if (entity.getId() == null || (Integer)entity.getId() == -1) continue;
            ids.add(entity.getId());
        }
        if (ids.isEmpty()) {
            return true;
        }
        String constraint = this.getTableIdCol() + " IN  (" + EntityHome.implode(ids.toArray()) + ")";
        return this.remove(constraint);
    }

    @Override
    public boolean removeAll() {
        return this.remove("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(T e) {
        Statement ps = null;
        boolean res = false;
        try {
            EntityHome entityHome = this;
            ps = entityHome.db.getConnection().prepareStatement(this.getUpdateSQL());
            int c = this.fillInStatement((PreparedStatement)ps, e);
            ps.setInt(c + 1, (Integer)e.getId());
            int numcol = ps.executeUpdate();
            res = numcol == 1;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "update location failed: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close ResultSet: " + es.getMessage(), es);
            }
        }
        return res;
    }

    @Override
    public boolean update(List<T> list) {
        boolean ok = true;
        for (IEntity e : list) {
            if (this.update((T)e)) continue;
            ok = false;
            break;
        }
        return ok;
    }

    protected PreparedStatement getPreparedStatement(String sql) throws SQLException {
        EntityHome entityHome = this;
        Connection conn = entityHome.db.getConnection();
        PreparedStatement ps = null;
        try {
            ps = conn.getMetaData().supportsGetGeneratedKeys() ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "getPreparedStatement failed: " + e.getMessage(), e);
            throw e;
        }
        return ps;
    }

    protected ResultSet getGeneratedKey(PreparedStatement ps) throws SQLException {
        ResultSet rs;
        block4: {
            rs = null;
            try {
                EntityHome entityHome = this;
                if (entityHome.db.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                    rs = ps.getGeneratedKeys();
                    break block4;
                }
                if (Configuration.DatabaseType == Configuration.DatabaseTypes.SQLITE) {
                    rs = ps.getGeneratedKeys();
                    break block4;
                }
                throw new SQLException("driver does not support retrieving generated keys.");
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "getGeneratedKey failed: " + e.getMessage(), e);
                throw e;
            }
        }
        return rs;
    }

    protected static String implode(Object[] obj) {
        String res;
        if (obj.length == 0) {
            res = "";
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append(obj[0]);
            for (int i = 1; i < obj.length; ++i) {
                sb.append(", ");
                sb.append(obj[i]);
            }
            res = sb.toString();
        }
        return res;
    }

    private String repeat(String str, int repeatCount) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < repeatCount; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }
}

