/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.db.homes;

import com.aiyc.server.standalone.core.Fingerprint;
import com.aiyc.server.standalone.core.Location;
import com.aiyc.server.standalone.core.Measurement;
import com.aiyc.server.standalone.core.Vector;
import com.aiyc.server.standalone.db.HomeFactory;
import com.aiyc.server.standalone.db.homes.EntityHome;
import com.waspring.wasdbtools.DaoUtil;
import com.waspring.wasdbtools.DatabaseConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FingerprintHome
extends EntityHome<Fingerprint> {
    private static final String[] TableCols = new String[]{"locationId", "measurementId"};
    private static final String TableName = "fingerprint";
    private static final String TableIdCol = "fingerprintId";
    private static final String selectFingerprints = " SELECT fingerprint.fingerprintId, " + HomeFactory.getLocationHome().getTableColNames() + ", " + HomeFactory.getMapHome().getTableColNames() + ", " + HomeFactory.getMeasurementHome().getTableColNames() + ", " + " readinginmeasurement.readingClassName, " + HomeFactory.getWiFiReadingHome().getTableColNames() + ", " + HomeFactory.getGSMReadingHome().getTableColNames() + ", " + HomeFactory.getBluetoothReadingHome().getTableColNames() + " FROM " + "fingerprint" + " INNER JOIN location ON fingerprint.locationId = location.locationId " + " INNER JOIN map ON location.mapId = map.mapId INNER JOIN measurement ON fingerprint.measurementId = measurement.measurementId " + " LEFT OUTER JOIN readinginmeasurement ON readinginmeasurement.measurementId = measurement.measurementId " + " LEFT OUTER JOIN wifireading ON wifireading.wifiReadingId = readinginmeasurement.readingId " + " LEFT OUTER JOIN gsmreading ON gsmreading.gsmReadingId = readinginmeasurement.readingId " + " LEFT OUTER JOIN bluetoothreading ON bluetoothreading.bluetoothReadingId = readinginmeasurement.readingId ";
    private static final String orderFingerprints = " fingerprint.fingerprintId, fingerprint.measurementId, readinginmeasurement.readingClassName ";

    @Override
    protected String getTableIdCol() {
        return TableIdCol;
    }

    @Override
    protected String[] getTableCols() {
        return TableCols;
    }

    @Override
    protected String getTableName() {
        return TableName;
    }

    @Override
    protected synchronized Fingerprint parseResultRow(ResultSet rs) throws SQLException {
        Fingerprint f = new Fingerprint();
        try {
            f.setId(rs.getInt(1));
            f.setLocation(HomeFactory.getLocationHome().parseResultRow(rs, 2));
            f.setMeasurement(HomeFactory.getMeasurementHome().parseResultRow(rs, HomeFactory.getLocationHome().getTableCols().length + 2 + HomeFactory.getMapHome().getTableCols().length + 2));
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "parseResultRow failed: " + e.getMessage(), e);
            throw e;
        }
        return f;
    }

    @Override
    public Fingerprint parseResultRow(ResultSet rs, int fromIndex) throws SQLException {
        return this.parseResultRow(rs, 1);
    }

    @Override
    public List<Fingerprint> getAll() {
        return this.getFingerprints(-1, -1, -1);
    }

    public synchronized List<Fingerprint> getAll(String mapId) {
        String ss = " exists (select 1 from   location where  location.locationId= " + this.getTableName() + "." + this.getTableCols()[0] + "" + "  and    location.mapId='" + mapId + "')";
        return this.getFingerprints(ss);
    }

    private synchronized List<Fingerprint> getFingerprints(String cnst) {
        return this.get(cnst);
    }

    private synchronized List<Fingerprint> getFingerprints(Integer fingerprintId, Integer locationId, Integer measurementId) {
        String cnst = "";
        if (fingerprintId != -1) {
            cnst = cnst + this.getTableName() + "." + this.getTableIdCol() + " = " + fingerprintId;
        } else if (locationId != -1) {
            cnst = cnst + this.getTableName() + "." + this.getTableCols()[0] + " = " + locationId;
        } else if (measurementId != -1) {
            cnst = cnst + this.getTableName() + "." + this.getTableCols()[1] + " = " + measurementId;
        }
        return this.get(cnst);
    }

    @Override
    protected String getSelectSQL() {
        return selectFingerprints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected synchronized List<Fingerprint> get(String constraint) {
        ArrayList<Fingerprint> res;
        block15: {
            String order;
            res = new ArrayList<Fingerprint>();
            String sql = this.getSelectSQL();
            if (constraint != null && constraint.length() > 0) {
                sql = sql + " WHERE " + constraint;
            }
            if ((order = this.getOrder()) != null && order.length() > 0) {
                sql = sql + " ORDER BY " + order;
            }
            this.log.finest(sql);
            ResultSet rs = null;
            rs = DaoUtil.queryData((String)sql, (Object[])new Object[0]);
            boolean first = true;
            while (!rs.isAfterLast()) {
                if (first) {
                    if (!rs.next()) break;
                    first = false;
                }
                res.add(this.parseResultRow(rs));
            }
            Object var8_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                break block15;
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close ResultSet: " + es.getMessage(), es);
            }
            break block15;
            {
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, "get failed: " + e.getMessage(), e);
                    Object var8_9 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        break block15;
                    }
                    catch (SQLException es) {
                        this.log.log(Level.WARNING, "failed to close ResultSet: " + es.getMessage(), es);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException es) {
                    this.log.log(Level.WARNING, "failed to close ResultSet: " + es.getMessage(), es);
                }
                throw throwable;
            }
        }
        return res;
    }

    @Override
    protected String getOrder() {
        return orderFingerprints;
    }

    public int getCount(Integer locationId) {
        if (locationId == null || locationId == -1) {
            return -1;
        }
        return this.getCount(this.getTableName() + "." + this.getTableCols()[0] + " = " + locationId);
    }

    public int getCount(Location location) {
        if (location == null || location.getId() == 0 || location.getId() == -1) {
            return -1;
        }
        return this.getCount(location.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected int getCount(String constraint) {
        int res;
        block16: {
            Statement stat;
            ResultSet rs;
            block15: {
                res = -1;
                String sql = "SELECT COUNT(*) FROM fingerprint";
                if (constraint != null && constraint.length() > 0) {
                    sql = sql + " WHERE " + constraint;
                }
                this.log.finest(sql);
                rs = null;
                stat = null;
                DatabaseConnection.getInstance();
                stat = DatabaseConnection.getConnection().createStatement();
                rs = stat.executeQuery(sql);
                if (!rs.next()) break block15;
                res = rs.getInt(1);
            }
            Object var8_6 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stat != null) {
                    stat.close();
                }
                break block16;
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close database resources: " + es.getMessage(), es);
            }
            break block16;
            {
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, "getCount failed: " + e.getMessage(), e);
                    Object var8_7 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stat != null) {
                            stat.close();
                        }
                        break block16;
                    }
                    catch (SQLException es) {
                        this.log.log(Level.WARNING, "failed to close database resources: " + es.getMessage(), es);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stat != null) {
                        stat.close();
                    }
                }
                catch (SQLException es) {
                    this.log.log(Level.WARNING, "failed to close database resources: " + es.getMessage(), es);
                }
                throw throwable;
            }
        }
        return res;
    }

    public int getCount() {
        return this.getCount((String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized Fingerprint add(Fingerprint fprint) {
        int locationId;
        FingerprintHome fingerprintHome = this;
        Connection conn = fingerprintHome.db.getConnection();
        Vector<PreparedStatement> vps = new Vector<PreparedStatement>();
        ResultSet rs = null;
        conn.setAutoCommit(false);
        Measurement m = (Measurement)fprint.getMeasurement();
        int measurementId = HomeFactory.getMeasurementHome().executeInsertUpdate(vps, m);
        m.setId(measurementId);
        HomeFactory.getWiFiReadingVectorHome().executeUpdate(vps, m.getWiFiReadings(), measurementId);
        HomeFactory.getGSMReadingVectorHome().executeUpdate(vps, m.getGsmReadings(), measurementId);
        HomeFactory.getBluetoothReadingVectorHome().executeUpdate(vps, m.getBluetoothReadings(), measurementId);
        Location l = (Location)fprint.getLocation();
        int n = locationId = l.getId() == null ? -1 : l.getId();
        if (locationId == -1) {
            locationId = HomeFactory.getLocationHome().executeInsertUpdate(vps, l);
            l.setId(locationId);
        }
        int fingerprintId = this.executeInsertUpdate(vps, fprint);
        conn.commit();
        Fingerprint fingerprint = this.getById(fingerprintId);
        Object var12_12 = null;
        try {
            conn.setAutoCommit(true);
            if (rs != null) {
                rs.close();
            }
            for (PreparedStatement p : vps) {
                if (p == null) continue;
                p.close();
            }
        }
        catch (SQLException es) {
            this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
        }
        return fingerprint;
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "add fingerprint failed: " + e.getMessage(), e);
            Object var12_13 = null;
            try {
                conn.setAutoCommit(true);
                if (rs != null) {
                    rs.close();
                }
                for (PreparedStatement p : vps) {
                    if (p == null) continue;
                    p.close();
                }
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
                {
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    conn.setAutoCommit(true);
                    if (rs != null) {
                        rs.close();
                    }
                    for (PreparedStatement p : vps) {
                        if (p == null) continue;
                        p.close();
                    }
                }
                catch (SQLException es) {
                    this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
                }
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public Fingerprint getById(Integer id) {
        if (id == null) {
            return null;
        }
        List<Fingerprint> res = this.getFingerprints(id, -1, -1);
        return res == null || res.size() == 0 ? null : res.get(0);
    }

    public List<Fingerprint> getByLocationId(Integer id) {
        if (id == null) {
            return new ArrayList<Fingerprint>();
        }
        return this.getFingerprints(-1, id, -1);
    }

    public synchronized Fingerprint getByMeasurementId(Integer id) {
        if (id == null) {
            return null;
        }
        List<Fingerprint> res = this.getFingerprints(-1, -1, id);
        return res == null || res.size() == 0 ? null : res.get(0);
    }

    @Override
    public int fillInStatement(PreparedStatement ps, Fingerprint t, int fromIndex) throws SQLException {
        return this.fillInStatement(ps, new Object[]{((Location)t.getLocation()).getId(), ((Measurement)t.getMeasurement()).getId()}, new int[]{4, 4}, fromIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean remove(String constraint) {
        String fingerprintsCnst = constraint != null && constraint.length() > 0 ? constraint : "1=1";
        String measurementsCnst = HomeFactory.getMeasurementHome().getTableIdCol() + " IN (SELECT " + HomeFactory.getFingerprintHome().getTableCols()[1] + " FROM " + HomeFactory.getFingerprintHome().getTableName() + " WHERE (" + fingerprintsCnst + ")) ";
        String readingInMeasurementCnst = " IN (SELECT readingId FROM readinginmeasurement WHERE (" + measurementsCnst + ")) ";
        String sql_m = " DELETE FROM " + HomeFactory.getMeasurementHome().getTableName() + " WHERE " + measurementsCnst;
        String sql_wifi = " DELETE FROM " + HomeFactory.getWiFiReadingHome().getTableName() + " WHERE " + HomeFactory.getWiFiReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_gsm = " DELETE FROM " + HomeFactory.getGSMReadingHome().getTableName() + " WHERE " + HomeFactory.getGSMReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_bluetooth = " DELETE FROM " + HomeFactory.getBluetoothReadingHome().getTableName() + " WHERE " + HomeFactory.getBluetoothReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_rinm = "DELETE FROM readinginmeasurement WHERE " + measurementsCnst;
        String sql_fp = "DELETE FROM " + HomeFactory.getFingerprintHome().getTableName() + " WHERE " + fingerprintsCnst;
        Statement stat = null;
        this.log.finest(sql_wifi);
        this.log.finest(sql_gsm);
        this.log.finest(sql_bluetooth);
        this.log.finest(sql_rinm);
        this.log.finest(sql_m);
        this.log.finest(sql_fp);
        int res = -1;
        FingerprintHome fingerprintHome = this;
        fingerprintHome.db.getConnection().setAutoCommit(false);
        FingerprintHome fingerprintHome2 = this;
        stat = fingerprintHome2.db.getConnection().createStatement();
        FingerprintHome fingerprintHome3 = this;
        if (fingerprintHome3.db.getConnection().getMetaData().supportsBatchUpdates()) {
            stat.addBatch(sql_wifi);
            stat.addBatch(sql_gsm);
            stat.addBatch(sql_bluetooth);
            stat.addBatch(sql_rinm);
            stat.addBatch(sql_fp);
            stat.addBatch(sql_m);
            int[] results = stat.executeBatch();
            if (results != null && results.length > 0) {
                res = results[results.length - 2];
            }
        } else {
            stat.executeUpdate(sql_wifi);
            stat.executeUpdate(sql_gsm);
            stat.executeUpdate(sql_bluetooth);
            stat.executeUpdate(sql_rinm);
            res = stat.executeUpdate(sql_fp);
            stat.executeUpdate(sql_m);
        }
        FingerprintHome fingerprintHome4 = this;
        fingerprintHome4.db.getConnection().commit();
        boolean bl = res > 0;
        Object var15_16 = null;
        try {
            FingerprintHome fingerprintHome5 = this;
            fingerprintHome5.db.getConnection().setAutoCommit(true);
            if (stat != null) {
                stat.close();
            }
        }
        catch (SQLException es) {
            this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
        }
        return bl;
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, "remove fp failed: " + e.getMessage(), e);
                Object var15_17 = null;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                try {
                    FingerprintHome fingerprintHome6 = this;
                    fingerprintHome6.db.getConnection().setAutoCommit(true);
                    if (stat != null) {
                        stat.close();
                    }
                }
                catch (SQLException es) {
                    this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
                }
                throw throwable;
            }
            try {
                FingerprintHome fingerprintHome7 = this;
                fingerprintHome7.db.getConnection().setAutoCommit(true);
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
            }
        }
        return false;
    }
}

