/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.db.homes;

import com.aiyc.server.standalone.core.Location;
import com.aiyc.server.standalone.core.Map;
import com.aiyc.server.standalone.db.HomeFactory;
import com.aiyc.server.standalone.db.homes.EntityHome;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationHome
extends EntityHome<Location> {
    private static final String[] TableCols = new String[]{"symbolicId", "mapId", "mapXCord", "mapYCord", "accuracy"};
    private static final String TableName = "location";
    private static final String TableIdCol = "locationId";

    @Override
    protected String getTableIdCol() {
        return TableIdCol;
    }

    @Override
    protected String[] getTableCols() {
        return TableCols;
    }

    @Override
    protected String getTableName() {
        return TableName;
    }

    @Override
    public Location parseResultRow(ResultSet rs, int fromIndex) throws SQLException {
        Location loc = new Location();
        try {
            loc.setId(rs.getInt(fromIndex));
            loc.setSymbolicID(rs.getString(fromIndex + 1));
            loc.setMapXcord(rs.getString(fromIndex + 3));
            loc.setMapYcord(rs.getString(fromIndex + 4));
            loc.setAccuracy(rs.getInt(fromIndex + 5));
            Map map = HomeFactory.getMapHome().parseResultRow(rs, fromIndex + 6);
            loc.setMap(map);
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "parseResultRow failed: " + e.getMessage(), e);
            throw e;
        }
        return loc;
    }

    public List<Location> getListByMapId(Integer id) {
        String constraint = "";
        if (id != -1) {
            constraint = constraint + " location.mapId = " + id;
        }
        return this.get(constraint);
    }

    public List<Location> getListByMap(Map m) {
        return this.getListByMapId(m.getId());
    }

    @Override
    public List<Location> getAll() {
        return this.getListByMapId(-1);
    }

    public Location getLocation(Integer locationId, String symbolicId) {
        if (locationId != -1) {
            String list = this.get("locationId = " + locationId);
            return list.size() == 0 ? null : (Location)list.get(0);
        }
        if (symbolicId != null && symbolicId.length() > 0) {
            String list = this.get("symbolicId = '" + symbolicId + "'");
            return list.size() == 0 ? null : (Location)list.get(0);
        }
        return null;
    }

    @Override
    public int fillInStatement(PreparedStatement ps, Location t, int fromIndex) throws SQLException {
        return this.fillInStatement(ps, new Object[]{t.getSymbolicID(), ((Map)t.getMap()).getId(), t.getMapXcord(), t.getMapYcord(), t.getAccuracy()}, new int[]{12, 4, 4, 4, 4}, fromIndex);
    }

    @Override
    protected String getSelectSQL() {
        return "SELECT " + this.getTableColNames() + ", " + HomeFactory.getMapHome().getTableColNames() + " FROM " + this.getTableName() + " INNER JOIN map ON location.mapId = map.mapId ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean remove(String constrain) {
        String locationCnst = constrain != null && constrain.length() > 0 ? constrain : "1=1";
        String fingerprintsCnst = HomeFactory.getFingerprintHome().getTableIdCol() + " IN (SELECT " + HomeFactory.getFingerprintHome().getTableIdCol() + " FROM " + HomeFactory.getFingerprintHome().getTableName() + " WHERE (" + locationCnst + ")) ";
        String measurementsCnst = HomeFactory.getMeasurementHome().getTableIdCol() + " IN (SELECT " + HomeFactory.getFingerprintHome().getTableCols()[1] + " FROM " + HomeFactory.getFingerprintHome().getTableName() + " WHERE (" + fingerprintsCnst + ")) ";
        String readingInMeasurementCnst = " IN (SELECT readingId FROM readinginmeasurement WHERE (" + measurementsCnst + ")) ";
        String sql_m = " DELETE FROM " + HomeFactory.getMeasurementHome().getTableName() + " WHERE " + measurementsCnst;
        String sql_wifi = " DELETE FROM " + HomeFactory.getWiFiReadingHome().getTableName() + " WHERE " + HomeFactory.getWiFiReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_gsm = " DELETE FROM " + HomeFactory.getGSMReadingHome().getTableName() + " WHERE " + HomeFactory.getGSMReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_bluetooth = " DELETE FROM " + HomeFactory.getBluetoothReadingHome().getTableName() + " WHERE " + HomeFactory.getBluetoothReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_rinm = "DELETE FROM readinginmeasurement WHERE " + measurementsCnst;
        String sql_fp = "DELETE FROM " + HomeFactory.getFingerprintHome().getTableName() + " WHERE " + locationCnst;
        String sql_loc = "DELETE FROM " + this.getTableName() + " WHERE " + locationCnst;
        Statement stat = null;
        this.log.finest(sql_wifi);
        this.log.finest(sql_gsm);
        this.log.finest(sql_bluetooth);
        this.log.finest(sql_rinm);
        this.log.finest(sql_m);
        this.log.finest(sql_fp);
        this.log.finest(sql_loc);
        int res = -1;
        LocationHome locationHome = this;
        locationHome.db.getConnection().setAutoCommit(false);
        LocationHome locationHome2 = this;
        stat = locationHome2.db.getConnection().createStatement();
        LocationHome locationHome3 = this;
        if (locationHome3.db.getConnection().getMetaData().supportsBatchUpdates()) {
            stat.addBatch(sql_wifi);
            stat.addBatch(sql_gsm);
            stat.addBatch(sql_bluetooth);
            stat.addBatch(sql_rinm);
            stat.addBatch(sql_fp);
            stat.addBatch(sql_m);
            stat.addBatch(sql_loc);
            int[] results = stat.executeBatch();
            if (results != null && results.length > 0) {
                res = results[results.length - 1];
            }
        } else {
            stat.executeUpdate(sql_wifi);
            stat.executeUpdate(sql_gsm);
            stat.executeUpdate(sql_bluetooth);
            stat.executeUpdate(sql_rinm);
            stat.executeUpdate(sql_fp);
            stat.executeUpdate(sql_m);
            res = stat.executeUpdate(sql_loc);
        }
        LocationHome locationHome4 = this;
        locationHome4.db.getConnection().commit();
        boolean bl = res > 0;
        Object var17_18 = null;
        try {
            LocationHome locationHome5 = this;
            locationHome5.db.getConnection().setAutoCommit(true);
            if (stat != null) {
                stat.close();
            }
        }
        catch (SQLException es) {
            this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
        }
        return bl;
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, "remove map failed: " + e.getMessage(), e);
                Object var17_19 = null;
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                try {
                    LocationHome locationHome6 = this;
                    locationHome6.db.getConnection().setAutoCommit(true);
                    if (stat != null) {
                        stat.close();
                    }
                }
                catch (SQLException es) {
                    this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
                }
                throw throwable;
            }
            try {
                LocationHome locationHome7 = this;
                locationHome7.db.getConnection().setAutoCommit(true);
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
            }
        }
        return false;
    }
}

