/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.db.homes;

import com.aiyc.server.standalone.core.Map;
import com.aiyc.server.standalone.db.HomeFactory;
import com.aiyc.server.standalone.db.homes.EntityHome;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapHome
extends EntityHome<Map> {
    public static final String[] TableCols = new String[]{"mapName", "mapURL"};
    public static final String TableName = "map";
    private static final String TableIdCol = "mapId";

    @Override
    protected String getTableName() {
        return TableName;
    }

    @Override
    protected String getTableIdCol() {
        return TableIdCol;
    }

    @Override
    protected String[] getTableCols() {
        return TableCols;
    }

    @Override
    public Map parseResultRow(ResultSet rs, int fromIndex) throws SQLException {
        Map map = new Map();
        try {
            map.setId(rs.getInt(fromIndex));
            map.setMapName(rs.getString(fromIndex + 1));
            map.setMapURL(rs.getString(fromIndex + 2));
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "parseResultRow failed: " + e.getMessage(), e);
            throw e;
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String constraint) {
        String mapCnst = constraint != null && constraint.length() > 0 ? constraint : "1=1";
        String locationCnst = HomeFactory.getLocationHome().getTableIdCol() + " IN (SELECT " + HomeFactory.getLocationHome().getTableIdCol() + " FROM " + HomeFactory.getLocationHome().getTableName() + " WHERE " + mapCnst + ")";
        String fingerprintsCnst = HomeFactory.getFingerprintHome().getTableIdCol() + " IN (SELECT " + HomeFactory.getFingerprintHome().getTableIdCol() + " FROM " + HomeFactory.getFingerprintHome().getTableName() + " WHERE (" + locationCnst + ")) ";
        String measurementsCnst = HomeFactory.getMeasurementHome().getTableIdCol() + " IN (SELECT " + HomeFactory.getFingerprintHome().getTableCols()[1] + " FROM " + HomeFactory.getFingerprintHome().getTableName() + " WHERE (" + fingerprintsCnst + ")) ";
        String readingInMeasurementCnst = " IN (SELECT readingId FROM readinginmeasurement WHERE (" + measurementsCnst + ")) ";
        String sql_m = " DELETE FROM " + HomeFactory.getMeasurementHome().getTableName() + " WHERE " + measurementsCnst;
        String sql_wifi = " DELETE FROM " + HomeFactory.getWiFiReadingHome().getTableName() + " WHERE " + HomeFactory.getWiFiReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_gsm = " DELETE FROM " + HomeFactory.getGSMReadingHome().getTableName() + " WHERE " + HomeFactory.getGSMReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_bluetooth = " DELETE FROM " + HomeFactory.getBluetoothReadingHome().getTableName() + " WHERE " + HomeFactory.getBluetoothReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_rinm = "DELETE FROM readinginmeasurement WHERE " + measurementsCnst;
        String sql_fp = "DELETE FROM " + HomeFactory.getFingerprintHome().getTableName() + " WHERE " + locationCnst;
        String sql_l = "DELETE FROM " + HomeFactory.getLocationHome().getTableName() + " WHERE " + mapCnst;
        String sql_map = "DELETE FROM " + this.getTableName() + " WHERE " + mapCnst;
        Statement stat = null;
        this.log.finest(sql_wifi);
        this.log.finest(sql_gsm);
        this.log.finest(sql_bluetooth);
        this.log.finest(sql_rinm);
        this.log.finest(sql_m);
        this.log.finest(sql_fp);
        this.log.finest(sql_l);
        this.log.finest(sql_map);
        try {
            int res = -1;
            MapHome mapHome = this;
            mapHome.db.getConnection().setAutoCommit(false);
            MapHome mapHome2 = this;
            stat = mapHome2.db.getConnection().createStatement();
            MapHome mapHome3 = this;
            if (mapHome3.db.getConnection().getMetaData().supportsBatchUpdates()) {
                stat.addBatch(sql_wifi);
                stat.addBatch(sql_gsm);
                stat.addBatch(sql_bluetooth);
                stat.addBatch(sql_rinm);
                stat.addBatch(sql_fp);
                stat.addBatch(sql_m);
                stat.addBatch(sql_l);
                stat.addBatch(sql_map);
                int[] results = stat.executeBatch();
                if (results != null && results.length > 0) {
                    res = results[results.length - 1];
                }
            } else {
                stat.executeUpdate(sql_wifi);
                stat.executeUpdate(sql_gsm);
                stat.executeUpdate(sql_bluetooth);
                stat.executeUpdate(sql_rinm);
                stat.executeUpdate(sql_fp);
                stat.executeUpdate(sql_m);
                stat.executeUpdate(sql_l);
                res = stat.executeUpdate(sql_map);
            }
            MapHome mapHome4 = this;
            mapHome4.db.getConnection().commit();
            boolean bl = res > 0;
            return bl;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "remove map failed: " + e.getMessage(), e);
        }
        finally {
            try {
                MapHome mapHome = this;
                mapHome.db.getConnection().setAutoCommit(true);
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
            }
        }
        return false;
    }

    @Override
    public int fillInStatement(PreparedStatement ps, Map t, int fromIndex) throws SQLException {
        return this.fillInStatement(ps, new Object[]{t.getMapName(), t.getMapURL()}, new int[]{12, 12}, fromIndex);
    }
}

