/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.db.homes;

import com.aiyc.server.standalone.core.Measurement;
import com.aiyc.server.standalone.core.Vector;
import com.aiyc.server.standalone.db.HomeFactory;
import com.aiyc.server.standalone.db.homes.EntityHome;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementHome
extends EntityHome<Measurement> {
    private static final String[] TableCols = new String[]{"timestamp"};
    private static final String TableName = "measurement";
    private static final String TableIdCol = "measurementId";
    private static final String selectMeasurements = " SELECT " + HomeFactory.getMeasurementHome().getTableColNames() + ", " + " readinginmeasurement.readingClassName, " + HomeFactory.getWiFiReadingHome().getTableColNames() + ", " + HomeFactory.getGSMReadingHome().getTableColNames() + ", " + HomeFactory.getBluetoothReadingHome().getTableColNames() + " FROM measurement INNER JOIN readinginmeasurement ON readinginmeasurement.measurementId = measurement.measurementId " + " LEFT OUTER JOIN wifireading ON wifireading.wifiReadingId = readinginmeasurement.readingId " + " LEFT OUTER JOIN gsmreading ON gsmreading.gsmReadingId = readinginmeasurement.readingId " + " LEFT OUTER JOIN bluetoothreading ON bluetoothreading.bluetoothReadingId = readinginmeasurement.readingId ";
    private static final String orderMeasurements = " measurement.measurementId, readinginmeasurement.readingClassName ";

    public List<Measurement> getAll(String mapId) {
        String where = " exists(select 1 from  location,fingerprint where location.locationId=fingerprint.locationId and location.mapId='" + mapId + "'" + "  and  fingerprint.measurementId=measurement.measurementId)";
        return this.get(where);
    }

    @Override
    protected String getTableIdCol() {
        return TableIdCol;
    }

    @Override
    protected String[] getTableCols() {
        return TableCols;
    }

    @Override
    protected String getTableName() {
        return TableName;
    }

    @Override
    public synchronized Measurement parseResultRow(ResultSet rs, int fromIndex) throws SQLException {
        Measurement m = new Measurement();
        try {
            if (!rs.isAfterLast()) {
                int mId = rs.getInt(fromIndex);
                m.setId(mId);
                m.setTimestamp(rs.getLong(fromIndex + 1));
                String readingClassName = rs.getString(fromIndex + 2);
                if (readingClassName == null) {
                    rs.next();
                } else {
                    while (!rs.isAfterLast() && mId == rs.getInt(fromIndex)) {
                        readingClassName = rs.getString(fromIndex + 2);
                        if (HomeFactory.getWiFiReadingVectorHome().getContainedObjectClassName().equals(readingClassName)) {
                            m.setWiFiReadings(HomeFactory.getWiFiReadingVectorHome().parseResultRow(rs, fromIndex + 3));
                            continue;
                        }
                        if (HomeFactory.getGSMReadingVectorHome().getContainedObjectClassName().equals(readingClassName)) {
                            m.setGSMReadings(HomeFactory.getGSMReadingVectorHome().parseResultRow(rs, fromIndex + 3 + HomeFactory.getWiFiReadingHome().getTableCols().length + 1));
                            continue;
                        }
                        if (HomeFactory.getBluetoothReadingVectorHome().getContainedObjectClassName().equals(readingClassName)) {
                            m.setBluetoothReadings(HomeFactory.getBluetoothReadingVectorHome().parseResultRow(rs, fromIndex + 3 + HomeFactory.getGSMReadingHome().getTableCols().length + 1 + HomeFactory.getWiFiReadingHome().getTableCols().length + 1));
                            continue;
                        }
                        this.log.fine("Result row has no matching readingClassName " + readingClassName);
                        rs.next();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "parseResultRow failed: " + e.getMessage(), e);
            throw e;
        }
        return m;
    }

    @Override
    public Measurement getById(Integer id) {
        String constraint = this.getTableName() + "." + this.getTableIdCol() + " = " + id;
        String list = this.get(constraint);
        if (list.size() == 0) {
            return null;
        }
        return (Measurement)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Measurement add(Measurement m) {
        MeasurementHome measurementHome = this;
        Connection conn = measurementHome.db.getConnection();
        Vector<PreparedStatement> vps = new Vector<PreparedStatement>();
        ResultSet rs = null;
        conn.setAutoCommit(false);
        int measurementId = HomeFactory.getMeasurementHome().executeInsertUpdate(vps, m);
        HomeFactory.getWiFiReadingVectorHome().executeUpdate(vps, m.getWiFiReadings(), measurementId);
        HomeFactory.getGSMReadingVectorHome().executeUpdate(vps, m.getGsmReadings(), measurementId);
        HomeFactory.getBluetoothReadingVectorHome().executeUpdate(vps, m.getBluetoothReadings(), measurementId);
        conn.commit();
        Measurement measurement = this.getById(measurementId);
        Object var8_8 = null;
        try {
            conn.setAutoCommit(true);
            if (rs != null) {
                rs.close();
            }
            for (PreparedStatement p : vps) {
                if (p == null) continue;
                p.close();
            }
        }
        catch (SQLException es) {
            this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
        }
        return measurement;
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "add fingerprint failed: " + e.getMessage(), e);
            Object var8_9 = null;
            try {
                conn.setAutoCommit(true);
                if (rs != null) {
                    rs.close();
                }
                for (PreparedStatement p : vps) {
                    if (p == null) continue;
                    p.close();
                }
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
                {
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    conn.setAutoCommit(true);
                    if (rs != null) {
                        rs.close();
                    }
                    for (PreparedStatement p : vps) {
                        if (p == null) continue;
                        p.close();
                    }
                }
                catch (SQLException es) {
                    this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
                }
                throw throwable;
            }
        }
        return null;
    }

    @Override
    protected String getSelectSQL() {
        return selectMeasurements;
    }

    @Override
    protected String getOrder() {
        return orderMeasurements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean remove(String constrain) {
        String measurementsCnst = constrain != null && constrain.length() > 0 ? constrain : "1=1";
        String readingInMeasurementCnst = " IN (SELECT readingId FROM readinginmeasurement WHERE (" + measurementsCnst + ")) ";
        String sql_m = " DELETE FROM " + HomeFactory.getMeasurementHome().getTableName() + " WHERE " + measurementsCnst;
        String sql_wifi = " DELETE FROM " + HomeFactory.getWiFiReadingHome().getTableName() + " WHERE " + HomeFactory.getWiFiReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_gsm = " DELETE FROM " + HomeFactory.getGSMReadingHome().getTableName() + " WHERE " + HomeFactory.getGSMReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_bluetooth = " DELETE FROM " + HomeFactory.getBluetoothReadingHome().getTableName() + " WHERE " + HomeFactory.getBluetoothReadingHome().getTableIdCol() + readingInMeasurementCnst;
        String sql_rinm = "DELETE FROM readinginmeasurement WHERE " + measurementsCnst;
        Statement stat = null;
        this.log.finest(sql_wifi);
        this.log.finest(sql_gsm);
        this.log.finest(sql_bluetooth);
        this.log.finest(sql_rinm);
        this.log.finest(sql_m);
        int res = -1;
        MeasurementHome measurementHome = this;
        measurementHome.db.getConnection().setAutoCommit(false);
        MeasurementHome measurementHome2 = this;
        stat = measurementHome2.db.getConnection().createStatement();
        MeasurementHome measurementHome3 = this;
        if (measurementHome3.db.getConnection().getMetaData().supportsBatchUpdates()) {
            stat.addBatch(sql_wifi);
            stat.addBatch(sql_gsm);
            stat.addBatch(sql_bluetooth);
            stat.addBatch(sql_rinm);
            stat.addBatch(sql_m);
            int[] results = stat.executeBatch();
            if (results != null && results.length > 0) {
                res = results[results.length - 1];
            }
        } else {
            stat.executeUpdate(sql_wifi);
            stat.executeUpdate(sql_gsm);
            stat.executeUpdate(sql_bluetooth);
            stat.executeUpdate(sql_rinm);
            res = stat.executeUpdate(sql_m);
        }
        MeasurementHome measurementHome4 = this;
        measurementHome4.db.getConnection().commit();
        boolean bl = res > 0;
        Object var13_14 = null;
        try {
            MeasurementHome measurementHome5 = this;
            measurementHome5.db.getConnection().setAutoCommit(true);
            if (stat != null) {
                stat.close();
            }
        }
        catch (SQLException es) {
            this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
        }
        return bl;
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, "remove map failed: " + e.getMessage(), e);
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    MeasurementHome measurementHome6 = this;
                    measurementHome6.db.getConnection().setAutoCommit(true);
                    if (stat != null) {
                        stat.close();
                    }
                }
                catch (SQLException es) {
                    this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
                }
                throw throwable;
            }
            try {
                MeasurementHome measurementHome7 = this;
                measurementHome7.db.getConnection().setAutoCommit(true);
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException es) {
                this.log.log(Level.WARNING, "failed to close statement: " + es.getMessage(), es);
            }
        }
        return false;
    }

    @Override
    public int fillInStatement(PreparedStatement ps, Measurement t, int fromIndex) throws SQLException {
        return this.fillInStatement(ps, new Object[]{t.getTimestamp()}, new int[]{-5}, fromIndex);
    }
}

