/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.db.homes;

import com.aiyc.server.standalone.core.measure.WiFiReading;
import com.aiyc.server.standalone.db.homes.EntityHome;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WiFiReadingHome
extends EntityHome<WiFiReading> {
    private static final String[] TableCols = new String[]{"bssid", "ssid", "rssi", "wepEnabled", "isInfrastructure"};
    private static final String TableName = "wifireading";
    private static final String TableIdCol = "wifiReadingId";

    @Override
    protected String getTableName() {
        return TableName;
    }

    @Override
    protected String getTableIdCol() {
        return TableIdCol;
    }

    @Override
    protected String[] getTableCols() {
        return TableCols;
    }

    @Override
    public synchronized WiFiReading parseResultRow(ResultSet rs, int fromIndex) throws SQLException {
        WiFiReading reading = new WiFiReading();
        try {
            reading.setId(rs.getInt(fromIndex));
            reading.setBssid(rs.getString(fromIndex + 1));
            reading.setSsid(rs.getString(fromIndex + 2));
            reading.setRssi(rs.getInt(fromIndex + 3));
            reading.setWepEnabled(rs.getBoolean(fromIndex + 4));
            reading.setInfrastructure(rs.getBoolean(fromIndex + 5));
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "parseResultRow failed: " + e.getMessage(), e);
            throw e;
        }
        return reading;
    }

    @Override
    public int fillInStatement(PreparedStatement ps, WiFiReading t, int fromIndex) throws SQLException {
        return this.fillInStatement(ps, new Object[]{t.getBssid(), t.getSsid(), t.getRssi(), t.isWepEnabled(), t.isInfrastructure()}, new int[]{12, 12, 4, -6, -6}, fromIndex);
    }
}

