/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.db.homes.vector;

import com.aiyc.server.standalone.core.ReadingInMeasurement;
import com.aiyc.server.standalone.db.HomeFactory;
import com.aiyc.server.standalone.db.IEntity;
import com.aiyc.server.standalone.db.homes.EntityHome;
import com.aiyc.server.standalone.util.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VectorHome<E extends IEntity<Integer>> {
    private Logger log = Log.getLogger();

    public abstract String getContainedObjectClassName();

    public abstract EntityHome<E> getObjectHome();

    public synchronized Vector<E> parseResultRow(ResultSet rs, int fromIndex) throws SQLException {
        Vector<E> v = new Vector<E>();
        try {
            int measurementId = rs.getInt("measurementId");
            v.add(this.getObjectHome().parseResultRow(rs, fromIndex));
            String readingClassName = rs.getString("readingClassName");
            while (rs.next() && measurementId == rs.getInt("measurementId") && readingClassName.equals(rs.getString("readingClassName"))) {
                v.add(this.getObjectHome().parseResultRow(rs, fromIndex));
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, " parseResultRow failed: " + e.getMessage(), e);
            throw e;
        }
        return v;
    }

    public void executeUpdate(Vector<PreparedStatement> vps, Vector<E> v, int foreignKeyId) throws SQLException {
        for (IEntity reading : v) {
            int readingId = this.getObjectHome().executeInsertUpdate(vps, reading);
            HomeFactory.getReadingInMeasurementHome().executeInsertUpdate(vps, new ReadingInMeasurement(foreignKeyId, readingId, this.getContainedObjectClassName()));
        }
    }
}

