/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.dzdp;

import com.aiyc.framework.utils.StringUtils;
import com.aiyc.server.standalone.dzdp.Businesses;
import com.aiyc.server.standalone.dzdp.BusinessesDetail;
import com.aiyc.server.standalone.dzdp.CouponDetail;
import com.aiyc.server.standalone.dzdp.DealsDetail;
import com.aiyc.server.standalone.util.ReflectHelper;
import com.waspring.wasdbtools.DaoUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataHandler {
    public void clearData(Businesses bs) throws Exception {
        String bsId = bs.business_id;
        if (StringUtils.nullToEmpty(bsId).equals("")) {
            return;
        }
        String sql = "delete from     s_restrictions where  deal_id in(select deal_id from  s_deals   where  business_id=?)";
        DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{bsId});
        sql = "delete from     s_deals_detail where  deal_id in(select deal_id from  s_deals   where  business_id=?)";
        DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{bsId});
        sql = "delete from   s_deals  where business_id=?";
        DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{bsId});
        sql = "delete from   s_businesses_detail   where  business_id=?";
        DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{bsId});
        sql = "delete from   s_coupon_detail  where  coupon_id in(select  coupon_id  from s_coupon     where    business_id=?  )";
        DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{bsId});
        sql = "delete from     s_coupon    where   business_id=?  ";
        DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{bsId});
        sql = "delete from     s_businesses    where    business_id=?  ";
        DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{bsId});
    }

    public void saveBusinesses(Businesses bs) throws Exception {
        String bsId = bs.business_id;
        if (StringUtils.nullToEmpty(bsId).equals("")) {
            return;
        }
        String sql = "insert into s_businesses(  `business_id` ,  `business_name` , `business_url` ,  `business_h5_url`,area_no,build_no,floor_no,door_no)values(?,?,?,?,?,?,?,?) ";
        DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{bs.business_id, bs.name, bs.business_url, bs.business_url, bs.area_no, bs.build_no, bs.floor_no, bs.door_no});
        if (!StringUtils.nullToEmpty(bs.coupon_id).equals("") && !"0".equals(bs.coupon_id)) {
            sql = "insert into s_coupon(  `coupon_id` ,  `business_id` , `coupon_description` ,  `coupon_url`)values(?,?,?,?) ";
            DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{bs.coupon_id, bs.business_id, bs.coupon_description, bs.coupon_url});
        }
        for (Businesses.Deal det : bs.deals) {
            sql = "insert into s_deals(  `deal_id` ,  `business_id` , `deals_description` ,  `deals_url`)values(?,?,?,?) ";
            DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{det.id, bs.business_id, det.description, det.url});
        }
    }

    public void saveBusinessesDetail(BusinessesDetail det) throws Exception {
        String bsId = det.business_id;
        if (StringUtils.nullToEmpty(bsId).equals("")) {
            return;
        }
        String[] tables = new String[]{"business_id", "name", "branch_name", "address", "city", "telephone", "latitude", "longitude", "avg_rating", "rating_img_url", "rating_s_img_url", "product_grade", "decoration_grade", "service_grade", "product_score", "decoration_score", "service_score", "avg_price", "review_count", "review_list_url", "business_url", "photo_url", "s_photo_url", "photo_count", "photo_list_url", "has_coupon", "has_deal", "deal_count", "has_online_reservation", "online_reservation_url", "regions", "categories"};
        String sql = " insert into  `s_businesses_detail` ( ";
        for (int i = 0; i < tables.length; ++i) {
            sql = i == tables.length - 1 ? sql + tables[i] : sql + tables[i] + ",";
        }
        sql = sql + ")  values(" + DaoUtil.makePix((int)tables.length) + ")";
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i].equalsIgnoreCase("regions") || tables[i].equalsIgnoreCase("categories")) {
                List paras = (List)ReflectHelper.getFileValue(det, tables[i]);
                Iterator rt = paras.iterator();
                String line = "";
                while (rt.hasNext()) {
                    String value = (String)rt.next();
                    line = line + value + ",";
                }
                list.add(line);
                continue;
            }
            list.add(ReflectHelper.getFileValue(det, tables[i]));
        }
        DaoUtil.executeUpdate((String)sql, (Object[])list.toArray());
    }

    public void saveDealsDetail(String bsId, DealsDetail deal) throws Exception {
        if (StringUtils.nullToEmpty(bsId).equals("")) {
            return;
        }
        if (deal.deal_id == null || "".equals(deal.deal_id) || "0".equals(deal.deal_id)) {
            return;
        }
        String[] tables = new String[]{"deal_id", "title", "description", "city", "list_price", "current_price", "purchase_count", "publish_date", "details", "purchase_deadline", "image_url", "s_image_url", "more_image_urls", "more_s_image_urls", "is_popular", "notice", "deal_url", "deal_h5_url", "commission_ratio", "regions", "categories"};
        String sql = " insert into  `s_deals_detail` ( ";
        for (int i = 0; i < tables.length; ++i) {
            sql = i == tables.length - 1 ? sql + tables[i] : sql + tables[i] + ",";
        }
        sql = sql + ")  values(" + DaoUtil.makePix((int)tables.length) + ")";
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i].equalsIgnoreCase("more_image_urls") || tables[i].equalsIgnoreCase("more_s_image_urls") || tables[i].equalsIgnoreCase("regions") || tables[i].equalsIgnoreCase("categories")) {
                List paras = (List)ReflectHelper.getFileValue(deal, tables[i]);
                Iterator rt = paras.iterator();
                String line = "";
                while (rt.hasNext()) {
                    String value = (String)rt.next();
                    line = line + value + ",";
                }
                list.add(line);
                continue;
            }
            list.add(ReflectHelper.getFileValue(deal, tables[i]));
        }
        DaoUtil.executeUpdate((String)sql, (Object[])list.toArray());
        DealsDetail.Restrictions o = deal.restrictions;
        if (o.special_tips != null && !"".equals(o.special_tips)) {
            sql = "insert into  s_restrictions(deal_id,is_reservation_required,is_refundable,special_tips) values(?,?,?,?)";
            DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{deal.deal_id, ReflectHelper.getFileValue(o, "is_reservation_required"), ReflectHelper.getFileValue(o, "is_refundable"), ReflectHelper.getFileValue(o, "special_tips")});
        }
    }

    public void saveCouponDetail(String bsId, CouponDetail cou) throws Exception {
        if (StringUtils.nullToEmpty(bsId).equals("")) {
            return;
        }
        if (StringUtils.nullToEmpty(cou.coupon_id).equals("") || "0".equals(cou.coupon_id)) {
            return;
        }
        String[] tables = new String[]{"coupon_id", "title", "description", "regions", "categories", "download_count", "publish_date", "expiration_date", "logo_img_url", "coupon_url", "coupon_h5_url"};
        String sql = " insert into  `s_coupon_detail` ( ";
        for (int i = 0; i < tables.length; ++i) {
            sql = i == tables.length - 1 ? sql + tables[i] : sql + tables[i] + ",";
        }
        sql = sql + ")  values(" + DaoUtil.makePix((int)tables.length) + ")";
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i].equalsIgnoreCase("regions") || tables[i].equalsIgnoreCase("categories")) {
                List paras = (List)ReflectHelper.getFileValue(cou, tables[i]);
                Iterator rt = paras.iterator();
                String line = "";
                while (rt.hasNext()) {
                    String value = (String)rt.next();
                    line = line + value + ",";
                }
                list.add(line);
                continue;
            }
            list.add(ReflectHelper.getFileValue(cou, tables[i]));
        }
        DaoUtil.executeUpdate((String)sql, (Object[])list.toArray());
    }
}

