/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.dzdp;

import com.aiyc.server.standalone.dzdp.Businesses;
import com.aiyc.server.standalone.dzdp.BusinessesDetail;
import com.aiyc.server.standalone.dzdp.CouponDetail;
import com.aiyc.server.standalone.dzdp.DealsDetail;
import com.aiyc.server.standalone.dzdp.INet;
import com.aiyc.server.standalone.json.GsonFactory;
import com.aiyc.server.standalone.util.Configuration;
import com.aiyc.server.standalone.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DzdpNet
implements INet {
    private Logger log = Log.getLogger();
    private String appKey = Configuration.appkey;
    private String secret = Configuration.secret;
    private Gson gson = GsonFactory.getGsonInstance();
    private JsonParser parser = new JsonParser();

    private String getRequestUrl(String url, Map<String, String> condition) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] keyArray = condition.keySet().toArray(new String[0]);
        Arrays.sort(keyArray);
        stringBuilder.append(this.appKey);
        for (Object key : keyArray) {
            stringBuilder.append((String)key).append(condition.get(key));
        }
        String codes = stringBuilder.append(this.secret).toString();
        String sign = DigestUtils.shaHex((String)codes).toUpperCase();
        stringBuilder = new StringBuilder();
        stringBuilder.append("appkey=").append(this.appKey).append("&sign=").append(sign);
        for (Map.Entry<String, String> entry : condition.entrySet()) {
            stringBuilder.append('&').append(entry.getKey()).append('=').append(DzdpNet.strToURL(entry.getValue()));
        }
        String queryString = stringBuilder.toString();
        return url + "?" + queryString;
    }

    @Override
    public int getSearchBussnissCount(String json) throws Exception {
        JsonElement root = this.parser.parse(json);
        if (root.isJsonObject()) {
            JsonObject rootobj = root.getAsJsonObject();
            JsonElement count = rootobj.get("count");
            int sum = (Integer)this.gson.fromJson(count, Integer.class);
            return sum;
        }
        return 0;
    }

    @Override
    public List<Businesses> searchBussniss(int page, String jd, String wd, int radias) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("page", page + "");
        map.put("latitude", wd + "");
        map.put("longitude", jd + "");
        map.put("radius", radias + "");
        map.put("offset_type", "1");
        String url = this.getRequestUrl(Configuration.find_businesses_url, map);
        String json = this.getHttpServerResponse(url);
        JsonElement root = this.parser.parse(json);
        if (root.isJsonObject()) {
            JsonObject rootobj = root.getAsJsonObject();
            JsonElement status = rootobj.get("status");
            String stats = (String)this.gson.fromJson(status, String.class);
            if (!"ok".equalsIgnoreCase(stats)) {
                this.log.log(Level.WARNING, "output:url=" + url + ",json=" + json, json + "\n");
                return null;
            }
            JsonElement businesses = rootobj.get("businesses");
            if (businesses.isJsonNull()) {
                return null;
            }
            List result = (List)this.gson.fromJson(businesses, new TypeToken<List<Businesses>>(){}.getType());
            return result;
        }
        return null;
    }

    @Override
    public BusinessesDetail getBussniss(String bussnissId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("business_ids", bussnissId);
        String url = this.getRequestUrl(Configuration.get_businesses_url, map);
        JsonElement root = this.parser.parse(this.getHttpServerResponse(url));
        if (root.isJsonObject()) {
            JsonObject rootobj = root.getAsJsonObject();
            JsonElement businesses = rootobj.get("businesses");
            if (businesses.isJsonNull()) {
                return new BusinessesDetail();
            }
            if (businesses.isJsonArray()) {
                List result = (List)this.gson.fromJson(businesses, new TypeToken<List<BusinessesDetail>>(){}.getType());
                if (result.size() > 0) {
                    return (BusinessesDetail)result.get(0);
                }
            } else {
                return (BusinessesDetail)this.gson.fromJson(businesses, new TypeToken<BusinessesDetail>(){}.getType());
            }
        }
        return new BusinessesDetail();
    }

    @Override
    public DealsDetail getDeals(String dealId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("deal_id", dealId);
        String url = this.getRequestUrl(Configuration.get_deal_url, map);
        JsonElement root = this.parser.parse(this.getHttpServerResponse(url));
        if (root.isJsonObject()) {
            JsonObject rootobj = root.getAsJsonObject();
            JsonElement businesses = rootobj.get("deals");
            if (businesses.isJsonNull()) {
                return new DealsDetail();
            }
            if (businesses.isJsonArray()) {
                List result = (List)this.gson.fromJson(businesses, new TypeToken<List<DealsDetail>>(){}.getType());
                if (result.size() > 0) {
                    return (DealsDetail)result.get(0);
                }
            } else {
                return (DealsDetail)this.gson.fromJson(businesses, new TypeToken<DealsDetail>(){}.getType());
            }
        }
        return new DealsDetail();
    }

    @Override
    public CouponDetail getCoupons(String couponId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("coupon_id", couponId);
        String url = this.getRequestUrl(Configuration.get_coupon_url, map);
        JsonElement root = this.parser.parse(this.getHttpServerResponse(url));
        if (root.isJsonObject()) {
            JsonObject rootobj = root.getAsJsonObject();
            JsonElement businesses = rootobj.get("coupons");
            if (businesses.isJsonNull()) {
                return new CouponDetail();
            }
            if (businesses.isJsonArray()) {
                List result = (List)this.gson.fromJson(businesses, new TypeToken<List<CouponDetail>>(){}.getType());
                if (result.size() > 0) {
                    return (CouponDetail)result.get(0);
                }
            } else {
                return (CouponDetail)this.gson.fromJson(businesses, new TypeToken<CouponDetail>(){}.getType());
            }
        }
        return new CouponDetail();
    }

    private String getHttpServerResponse(String url) throws Exception {
        URL getUrl = new URL(url);
        System.out.println(url);
        HttpURLConnection connection = (HttpURLConnection)getUrl.openConnection();
        connection.connect();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
        StringBuffer lines = new StringBuffer(9082);
        String line = "";
        while ((line = reader.readLine()) != null) {
            lines.append(line).append(System.getProperty("line.separator"));
        }
        reader.close();
        connection.disconnect();
        System.out.println(lines.toString());
        return lines.toString();
    }

    private static String strToURL(String str) {
        String result = null;
        try {
            result = URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }
}

