/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.locator;

import com.aiyc.server.standalone.core.Fingerprint;
import com.aiyc.server.standalone.core.Location;
import com.aiyc.server.standalone.core.Measurement;
import com.aiyc.server.standalone.core.measure.WiFiReading;
import com.aiyc.server.standalone.db.HomeFactory;
import com.aiyc.server.standalone.db.homes.FingerprintHome;
import com.aiyc.server.standalone.db.homes.MeasurementHome;
import com.aiyc.server.standalone.locator.ILocator;
import com.aiyc.server.standalone.locator.MeasurementComparator;
import com.aiyc.server.standalone.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BaseLocator
implements ILocator {
    MeasurementHome measurementHome = null;
    FingerprintHome fingerprintHome = null;
    Logger log;
    Level loglevel = Level.FINEST;
    private static double ID_POS_CONTRIBUTION = 1.0;
    private static double ID_NEG_CONTRIBUTION = -0.4;
    public static double SIGNAL_CONTRIBUTION = 1.0;
    public static double SIGNAL_PENALTY_THRESHOLD = 10.0;
    public static double SIGNAL_GRAPH_LEVELING = 0.2;
    public static final int LOCATION_KNOWN = 10;
    public static final int LOCATION_UNKNOWN = 0;
    public static int LOCATION_THRESHOLD = 2;
    public static boolean debug = false;

    public BaseLocator() {
        this.measurementHome = HomeFactory.getMeasurementHome();
        this.fingerprintHome = HomeFactory.getFingerprintHome();
        this.log = Log.getLogger();
        this.loadParameters();
    }

    public void loadParameters() {
        Properties p = new Properties();
        File f = new File("waspringlocator.properties");
        if (f.exists()) {
            try {
                FileInputStream reader = new FileInputStream(f);
                p.load(reader);
                debug = Boolean.valueOf(p.getProperty("debug", Boolean.valueOf(debug).toString()));
                LOCATION_THRESHOLD = Integer.parseInt(p.getProperty("LOCATION_THRESHOLD", new Integer(LOCATION_THRESHOLD).toString()));
                ID_POS_CONTRIBUTION = Double.parseDouble(p.getProperty("ID_POS_CONTRIBUTION", new Double(ID_POS_CONTRIBUTION).toString()));
                ID_NEG_CONTRIBUTION = Double.parseDouble(p.getProperty("ID_NEG_CONTRIBUTION", new Double(ID_NEG_CONTRIBUTION).toString()));
                SIGNAL_CONTRIBUTION = Double.parseDouble(p.getProperty("SIGNAL_CONTRIBUTION", new Double(SIGNAL_CONTRIBUTION).toString()));
                SIGNAL_PENALTY_THRESHOLD = Double.parseDouble(p.getProperty("SIGNAL_PENALTY_THRESHOLD", new Double(SIGNAL_PENALTY_THRESHOLD).toString()));
                SIGNAL_GRAPH_LEVELING = Double.parseDouble(p.getProperty("SIGNAL_GRAPH_LEVELING", new Double(SIGNAL_GRAPH_LEVELING).toString()));
            }
            catch (Exception e) {
                Log.getLogger().log(Level.WARNING, "RedpinLocator Config initialization failed: " + e.getMessage(), e);
            }
        }
    }

    public Location locate(Measurement currentMeasurement) {
        Measurement bestMatch;
        Fingerprint f;
        if (debug) {
            this.loadParameters();
        }
        Location loc = null;
        List list = this.measurementHome.getAll();
        TreeSet<Measurement> hits = new TreeSet<Measurement>(new MeasurementComparator(currentMeasurement));
        for (Measurement m : list) {
            Location l;
            Fingerprint fp;
            int level = this.measurementSimilarityLevel(m, currentMeasurement);
            if (debug && (fp = this.fingerprintHome.getByMeasurementId(m.getId())) != null && (l = (Location)fp.getLocation()) != null) {
                this.log.log(Level.FINE, "location \"" + l.getMap().getMapName() + l.getSymbolicID() + "\" achieved similarity level " + level);
            }
            if (level <= LOCATION_THRESHOLD) continue;
            hits.add(m);
        }
        if (hits.size() > 0 && (f = this.fingerprintHome.getByMeasurementId((bestMatch = hits.first()).getId())) != null) {
            loc = (Location)f.getLocation();
            loc.setAccuracy(this.measurementSimilarityLevel(bestMatch, currentMeasurement));
            if (debug) {
                this.log.log(Level.FINE, "Best match: \"" + loc.getMap().getMapName() + loc.getSymbolicID() + "\" achieved similarity level " + loc.getAccuracy());
            }
        }
        return loc;
    }

    public int measurementSimilarityLevel(com.aiyc.base.core.Measurement t, com.aiyc.base.core.Measurement o) {
        Location mloc = null;
        if (debug) {
            Fingerprint tf = this.fingerprintHome.getByMeasurementId(((Measurement)t).getId());
            if (tf != null) {
                mloc = (Location)tf.getLocation();
            }
            if (mloc != null) {
                this.log.log(this.loglevel, "Calculating similarity Level between current measurement and " + mloc.getMap().getMapName() + mloc.getSymbolicID());
            } else {
                this.log.log(this.loglevel, "Calculating similarity Level between current Measurements and #" + ((Measurement)t).getId());
            }
        } else {
            this.log.log(this.loglevel, "Calculating similarity Level between current Measurements and #" + ((Measurement)t).getId());
        }
        double totalCredit = 0.0;
        double account = 0.0;
        Vector this_vect = t.getWiFiReadings();
        Vector other_vect = o.getWiFiReadings();
        int matches = 0;
        for (int i = 0; i < this_vect.size(); ++i) {
            WiFiReading this_wifi = (WiFiReading)this_vect.elementAt(i);
            for (int j = 0; j < other_vect.size(); ++j) {
                WiFiReading other_wifi = (WiFiReading)other_vect.elementAt(j);
                if (this_wifi == null || this_wifi.getBssid() == null || other_wifi == null || other_wifi.getBssid() == null || !this_wifi.getBssid().equals(other_wifi.getBssid())) continue;
                account += ID_POS_CONTRIBUTION;
                account += this.signalContribution(this_wifi.getRssi(), other_wifi.getRssi());
                ++matches;
            }
        }
        int readings = Math.max(this_vect.size(), other_vect.size());
        account += (double)(readings - matches) * ID_NEG_CONTRIBUTION;
        this.log.log(this.loglevel, "WiFi ID penalty: (" + readings + " read - " + matches + " matches) * " + ID_NEG_CONTRIBUTION + " = " + (double)(readings - matches) * ID_NEG_CONTRIBUTION);
        totalCredit += (double)this_vect.size() * ID_POS_CONTRIBUTION;
        totalCredit += (double)this_vect.size() * SIGNAL_CONTRIBUTION;
        int factor = 10;
        int accuracy = 0;
        if (account > 0.0) {
            double a = account / totalCredit * (double)factor + 0.0;
            accuracy = (int)Math.floor(a + 0.5);
        }
        String logmsg = "Comparing measurements...\n-> Testing Measur: " + (mloc == null ? ((Measurement)t).getId() : mloc.getMap().getMapName() + mloc.getSymbolicID()) + "\n" + "-> Credit achieved: " + account + "\n" + "-> Total Credit possible: " + totalCredit + "\n" + "-> Accuracy achieved: " + accuracy;
        this.log.log(this.loglevel, logmsg);
        return accuracy;
    }

    public Boolean measurmentAreSimilar(com.aiyc.base.core.Measurement t, com.aiyc.base.core.Measurement o) {
        if (this.measurementSimilarityLevel(t, o) > LOCATION_THRESHOLD) {
            return true;
        }
        return false;
    }

    private double signalContribution(double rssi1, double rssi2) {
        double base = rssi1;
        this.log.log(this.loglevel, "  Base: " + base);
        double diff = Math.abs(rssi1 - rssi2);
        this.log.log(this.loglevel, "  Diff: " + diff);
        double x = diff / base;
        this.log.log(this.loglevel, "  Diff percents of base: " + x);
        if (x > 0.0) {
            double y = 1.0 / x;
            this.log.log(this.loglevel, "  Current Contribution: " + y);
            double t = SIGNAL_PENALTY_THRESHOLD / base;
            y -= 1.0 / t;
            this.log.log(this.loglevel, "  Shifted Contribution: " + (y *= SIGNAL_GRAPH_LEVELING) + " (shifted by " + t + ")");
            if (-1.0 * SIGNAL_CONTRIBUTION <= y && y <= SIGNAL_CONTRIBUTION) {
                this.log.log(this.loglevel, "  Returned: " + y);
                return y;
            }
            this.log.log(this.loglevel, "  Returned: " + SIGNAL_CONTRIBUTION + " (CUTOFF, y was " + y + ")");
            return SIGNAL_CONTRIBUTION;
        }
        this.log.log(this.loglevel, "  Returned: " + SIGNAL_CONTRIBUTION + " (diff was zero)");
        return SIGNAL_CONTRIBUTION;
    }
}

