/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.longwait;

import com.aiyc.server.standalone.exp.NotifyException;
import com.aiyc.server.standalone.longwait.Client;
import com.aiyc.server.standalone.longwait.ExcepitonTrace;
import com.aiyc.server.standalone.longwait.Notifyer;
import com.aiyc.server.standalone.longwait.Server;
import com.aiyc.server.standalone.longwait.SokectCallBack;
import com.aiyc.server.standalone.util.Configuration;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AloneServer
implements Server,
Runnable {
    private List<Notifyer> ln = new Vector<Notifyer>();
    private int port = 7887;
    private ServerSocket serverSocket = null;
    private ExecutorService executorService;
    private final int POOL_SIZE = 4;
    private List<Client> sokects = new Vector<Client>(1024);
    private static Log log = LogFactory.getLog(AloneServer.class);
    private boolean isStart;
    private List<String> msgs = new ArrayList<String>(1024);
    private Object lock = new Object();

    @Override
    public synchronized void addNotify(Notifyer er) {
        if (!this.ln.contains(er)) {
            this.ln.add(er);
        }
    }

    @Override
    public void startNotify() throws NotifyException {
        for (Notifyer next : this.ln) {
            next.send();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                Socket socket = null;
                while (true) {
                    this.isStart = true;
                    socket = this.serverSocket.accept();
                    System.out.println("\u8fde\u63a5\u5ba2\u6237\u7aef\uff1a" + socket.getInetAddress().getHostAddress());
                    this.executorService.execute(new SokectCallBack(this, socket));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e);
                this.isStart = false;
                Object var3_3 = null;
                try {
                    this.destory();
                }
                catch (Exception e2) {
                    log.error((Object)e2);
                    e2.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                this.destory();
            }
            catch (Exception e2) {
                log.error((Object)e2);
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    @Override
    public Client getSokect(int id) {
        for (Client c : this.getClients()) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    @Override
    public Client getSokect(String ip, int port) {
        for (Client c : this.getClients()) {
            Socket s = c.getSocket();
            if (!s.getInetAddress().getHostAddress().equals(ip) || s.getPort() != port) continue;
            return c;
        }
        return null;
    }

    @Override
    public void removeSokect(int id) {
        Client c = this.getSokect(id);
        if (c != null) {
            this.removeSokect(c);
        }
    }

    @Override
    public void removeSokect(String ip, int port) {
        Client c = this.getSokect(ip, port);
        if (c != null) {
            this.removeSokect(c);
        }
    }

    @Override
    public List<Client> getClients() {
        return this.sokects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destory() {
        try {
            block4: {
                try {
                    if (this.serverSocket == null) break block4;
                    this.serverSocket.close();
                }
                catch (Exception e) {
                    log.error((Object)e);
                    e.printStackTrace();
                    Object var3_2 = null;
                    this.serverSocket = null;
                    this.isStart = false;
                }
            }
            Object var3_1 = null;
            this.serverSocket = null;
            this.isStart = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.serverSocket = null;
            this.isStart = false;
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        AloneServer server = AloneServer.instance();
        server.start();
        if (args.length <= 0 || args[0].indexOf("-c") != -1 || args[0].indexOf("-i") != -1 || args[0].indexOf("-u") != -1 || args[0].indexOf("-b") != -1) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AloneServer() {
        this.port = this.getPort();
        try {
            try {
                this.bingToServerPort(this.port);
                this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 4);
            }
            catch (Exception e) {
                System.out.println("\u7ed1\u5b9a\u7aef\u53e3\u4e0d\u6210\u529f!" + e.getMessage());
                e.printStackTrace();
                log.error((Object)e);
                Object var3_2 = null;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    private void bingToServerPort(int port) {
        try {
            this.serverSocket = new ServerSocket(port);
            log.debug((Object)("\u670d\u52a1\u542f\u52a8!\u7aef\u53e3:" + port));
        }
        catch (Exception e) {
            log.error((Object)("\u542f\u52a8\u670d\u52a1\u5931\u8d25\uff01" + e));
            e.printStackTrace();
        }
    }

    @Override
    public int getPort() {
        return Configuration.LongServerPort;
    }

    public static AloneServer instance() {
        return AloneServerImpl.alone;
    }

    @Override
    public void start() {
        if (this.isStart) {
            log.warn((Object)"\u670d\u52a1\u5df2\u7ecf\u542f\u52a8\uff01");
            return;
        }
        new Thread(this).start();
    }

    @Override
    public synchronized void addSokect(Client socket) {
        if (this.sokects.contains(socket)) {
            return;
        }
        this.sokects.add(socket);
    }

    @Override
    public synchronized void removeSokect(Client socket) {
        this.sokects.remove(socket);
    }

    @Override
    public boolean isStart() {
        return this.isStart;
    }

    public List<String> qetCallBackMsg() {
        return this.msgs;
    }

    public synchronized void addCallBack(String msg) {
        if (this.msgs.size() > 1024) {
            this.msgs.clear();
        }
        this.msgs.add(msg);
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMsg(Socket socket, byte[] b) {
        try {
            Object object = this.lock;
            synchronized (object) {
                OutputStream writer = socket.getOutputStream();
                writer.write(b);
                writer.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error((Object)("\u670d\u52a1\u5668\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a" + socket.getInetAddress().getHostAddress() + "(" + socket.getPort() + ")" + ExcepitonTrace.getExceptionTraceInfo(ex)));
        }
    }

    @Override
    public void sendAll(byte[] b) {
        Iterator<Client> it = this.getClients().iterator();
        while (it.hasNext()) {
            this.sendMsg(it.next().getSocket(), b);
        }
    }

    @Override
    public Client getSokect(String userNo) {
        for (Client c : this.getClients()) {
            if (c.getId() == null || !c.getId().equals(userNo)) continue;
            return c;
        }
        return null;
    }

    public class ShutdownHandler
    implements Runnable {
        private Server server = null;

        public ShutdownHandler(Server server) {
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.warn((Object)"Control-C caught. Shutting down gracefully...");
            this.server.destory();
            try {
                Server server = this.server;
                synchronized (server) {
                    log.info((Object)"Waiting for server shutdown...");
                    this.server.wait();
                    log.info((Object)"Server shut down, now quitting...");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                log.error((Object)e);
            }
        }
    }

    private static class AloneServerImpl {
        private static AloneServer alone = new AloneServer();

        private AloneServerImpl() {
        }
    }
}

