/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.net;

import com.aiyc.server.standalone.net.ImageHandler;
import com.aiyc.server.standalone.net.RequestHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.net.Socket;

public class ConnectionHandler
implements Runnable {
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;

    public ConnectionHandler(Socket s) throws IOException {
        this.socket = s;
        this.in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
    }

    public void run() {
        long n1 = System.currentTimeMillis();
        String ip = this.socket.getLocalAddress().getHostAddress();
        String port = String.valueOf(this.socket.getPort());
        try {
            RequestHandler rhandler = new RequestHandler();
            ImageHandler imgHandler = new ImageHandler(this.in, this.out, ip, port);
            String line = this.in.readLine();
            System.out.println("request line=" + line);
            long n2 = System.currentTimeMillis();
            System.out.println("read cost" + (n2 - n1) / 1000L + "ms");
            if (line != null) {
                if (line.indexOf("GET") == 0 || line.indexOf("POST") == 0) {
                    imgHandler.handle(line);
                } else {
                    String lines = new BufferedReader(new InputStreamReader((InputStream)new StringBufferInputStream(line), "UTF-8")).readLine();
                    long n3 = System.currentTimeMillis();
                    String res = rhandler.request(lines);
                    long n4 = System.currentTimeMillis();
                    System.out.println("response cost" + (n4 - n3) / 1000L + "ms");
                    this.out.write((res + "\r\n").getBytes());
                }
            }
            this.out.flush();
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double n5 = System.currentTimeMillis();
        System.out.println("all cost" + (n5 - (double)n1) / 1000.0 + "ms");
    }
}

