/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.net;

import com.aiyc.server.standalone.net.GetLocationHandler;
import com.aiyc.server.standalone.net.GetLocationListHandler;
import com.aiyc.server.standalone.net.GetMapListHandler;
import com.aiyc.server.standalone.net.IHandler;
import com.aiyc.server.standalone.net.RemoveLocationHandler;
import com.aiyc.server.standalone.net.RemoveMapHandler;
import com.aiyc.server.standalone.net.RequestHandler;
import com.aiyc.server.standalone.net.SetFingerprintHandler;
import com.aiyc.server.standalone.net.SetMapHandler;
import com.aiyc.server.standalone.net.UnknownHandler;
import com.aiyc.server.standalone.net.UpdateLocationHandler;
import com.aiyc.server.standalone.util.ConsoleData;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;

public class HandlerFactory {
    private static Properties p = null;
    private static UnknownHandler unkownHandler;
    private static SetMapHandler setMapHandler;
    private static SetFingerprintHandler setFingerprintHandler;
    private static GetMapListHandler getMapListHandler;
    private static RemoveMapHandler removeMapHandler;
    private static UpdateLocationHandler updateLocationHandler;
    private static GetLocationHandler getLocationHandler;
    private static GetLocationListHandler getLocationListHandler;
    private static RemoveLocationHandler removeLocationHandler;

    public static IHandler findHandler(RequestHandler.RequestType type) {
        switch (type) {
            case setFingerprint: {
                return HandlerFactory.getSetFingerprintHandler();
            }
            case getMapList: {
                return HandlerFactory.getGetMapHandler();
            }
            case setMap: {
                return HandlerFactory.getSetMapHandler();
            }
            case removeMap: {
                return HandlerFactory.getRemoveMapHandler();
            }
            case getLocation: {
                return HandlerFactory.getGetLocationHandler();
            }
            case getLocationList: {
                return HandlerFactory.getGetLocationListHandler();
            }
            case updateLocation: {
                return HandlerFactory.getUpdateLocationHandler();
            }
            case removeLocation: {
                return HandlerFactory.getRemoveLocationHandler();
            }
        }
        return HandlerFactory.getUnknownHandler();
    }

    public static IHandler annoHandler(String type) {
        IHandler hand = (IHandler)((Map)ConsoleData.instance().getCachedValue("hander")).get(type);
        if (hand == null) {
            return HandlerFactory.getUnknownHandler();
        }
        return hand;
    }

    public static IHandler findHandler(String type) {
        if (p == null) {
            p = new Properties();
            File f = new File("hander.properties");
            if (f.exists()) {
                try {
                    FileInputStream reader = new FileInputStream(f);
                    p.load(reader);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return HandlerFactory.getUnknownHandler();
                }
            } else {
                return HandlerFactory.getUnknownHandler();
            }
        }
        String path = p.getProperty(type);
        try {
            return (IHandler)Class.forName(path).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return HandlerFactory.getUnknownHandler();
        }
    }

    private static UnknownHandler getUnknownHandler() {
        if (unkownHandler == null) {
            unkownHandler = new UnknownHandler();
        }
        return unkownHandler;
    }

    private static SetMapHandler getSetMapHandler() {
        if (setMapHandler == null) {
            setMapHandler = new SetMapHandler();
        }
        return setMapHandler;
    }

    private static SetFingerprintHandler getSetFingerprintHandler() {
        if (setFingerprintHandler == null) {
            setFingerprintHandler = new SetFingerprintHandler();
        }
        return setFingerprintHandler;
    }

    public static GetMapListHandler getGetMapHandler() {
        if (getMapListHandler == null) {
            getMapListHandler = new GetMapListHandler();
        }
        return getMapListHandler;
    }

    public static RemoveMapHandler getRemoveMapHandler() {
        if (removeMapHandler == null) {
            removeMapHandler = new RemoveMapHandler();
        }
        return removeMapHandler;
    }

    public static UpdateLocationHandler getUpdateLocationHandler() {
        if (updateLocationHandler == null) {
            updateLocationHandler = new UpdateLocationHandler();
        }
        return updateLocationHandler;
    }

    public static GetLocationHandler getGetLocationHandler() {
        if (getLocationHandler == null) {
            getLocationHandler = new GetLocationHandler();
        }
        return getLocationHandler;
    }

    public static GetLocationListHandler getGetLocationListHandler() {
        if (getLocationListHandler == null) {
            getLocationListHandler = new GetLocationListHandler();
        }
        return getLocationListHandler;
    }

    public static RemoveLocationHandler getRemoveLocationHandler() {
        if (removeLocationHandler == null) {
            removeLocationHandler = new RemoveLocationHandler();
        }
        return removeLocationHandler;
    }
}

