/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.net;

import com.aiyc.framework.utils.StringUtils;
import com.aiyc.server.standalone.util.Configuration;
import com.aiyc.server.standalone.util.Log;
import com.waspring.wasdbtools.DaoUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImageHandler {
    private DataInputStream in;
    private DataOutputStream out;
    static final String CRLF = "\r\n";
    static final int HTTP_OK = 200;
    static final int HTTP_NOT_FOUND = 404;
    static final int SUCCESS_CODE = 1;
    static final int FAIL_CODE = 0;
    private String ip = "";
    private String port = "";
    static final int BUFFER_SIZE = 1024;
    private Logger log = Log.getLogger();

    public ImageHandler(DataInputStream in, DataOutputStream out) {
        this.in = in;
        this.out = out;
    }

    public ImageHandler(DataInputStream in, DataOutputStream out, String ip, String port) {
        this.in = in;
        this.out = out;
        this.ip = ip;
        this.port = port;
    }

    public void handle(String firstLine) {
        StringTokenizer tokenizer = new StringTokenizer(firstLine);
        String httpMethod = tokenizer.nextToken();
        String httpQuery = tokenizer.nextToken();
        if (httpMethod.equals("GET")) {
            this.requestGET(httpQuery);
        }
        if (httpMethod.equals("POST")) {
            this.requestPOST(firstLine);
        }
    }

    public void requestGET(String httpQuery) {
        if (!httpQuery.equals("/")) {
            String fileName = httpQuery.substring(1);
            File f = new File(Configuration.ImageUploadPath + "/" + fileName);
            if (f.exists() && f.canRead()) {
                Log.getLogger().log(Level.FINER, "sending map image " + fileName);
                this.sendResponse(200, fileName, true, 1, "sending map image successful!");
            } else {
                Log.getLogger().log(Level.FINE, "client requested non existing map image " + fileName);
                this.sendResponse(404);
            }
        } else {
            this.sendResponse(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestPOST(String firstLine) {
        block23: {
            block22: {
                dataLength = 0;
                boundary = "";
                fileout = null;
                userNo = "";
                rtnMsg = "SUCCESS!";
                try {
                    try {}
                    catch (IOException e) {
                        this.log.log(Level.WARNING, e.getMessage(), e);
                        var14_18 = null;
                        this.log.log(Level.FINE, "SERVER finished");
                        if (fileout == null) return;
                        try {
                            fileout.close();
                            return;
                        }
                        catch (IOException e) {
                            return;
                        }
                    }
                }
                catch (Throwable var13_26) {
                    var14_19 = null;
                    this.log.log(Level.FINE, "SERVER finished");
                    if (fileout == null) throw var13_26;
                    ** try [egrp 3[TRYBLOCK] [9 : 728->736)] { 
lbl26:
                    // 1 sources

                    fileout.close();
                    throw var13_26;
lbl28:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var13_26;
                }
                do {
                    currentLine = this.in.readLine();
                    this.log.log(Level.FINE, "currentLine=" + currentLine);
                    if (currentLine == null) break block22;
                } while (currentLine.toLowerCase().indexOf("Content-Type: multipart/form-data".toLowerCase()) == -1);
                boundary = currentLine.split("boundary=")[1];
            }
            do {
                currentLine = this.in.readLine();
                this.log.log(Level.FINE, "currentLine=" + currentLine);
                if (currentLine == null) break block23;
            } while (currentLine.indexOf("--" + boundary) == -1);
            line = this.in.readLine();
            line = line.split("filename=")[1].replaceAll("\"", "");
            sps = line.split(";USER_NO=");
            filename = sps[0];
            if (sps.length == 2) {
                userNo = sps[1];
            }
            if (null == (filename = (filelist = filename.split("\\" + System.getProperty("file.separator")))[filelist.length - 1]) || "".equals(filename)) {
                Log.getLogger().log(Level.FINE, "filename is empty!");
                rtnMsg = "filename is empty!";
                this.sendResponse(200, "", false, 0, rtnMsg);
                var14_15 = null;
                this.log.log(Level.FINE, "SERVER finished");
                if (fileout == null) return;
                ** try [egrp 3[TRYBLOCK] [9 : 728->736)] { 
lbl59:
                // 1 sources

                fileout.close();
                return;
lbl61:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            if (!filename.equals("icsfile")) {
                Log.getLogger().log(Level.FINE, "unauthorized client tried to upload  image");
                rtnMsg = "unauthorized client tried to upload  image!";
                this.sendResponse(200, "", false, 0, rtnMsg);
                var14_16 = null;
                this.log.log(Level.FINE, "SERVER finished");
                if (fileout == null) return;
                ** try [egrp 3[TRYBLOCK] [9 : 728->736)] { 
lbl73:
                // 1 sources

                fileout.close();
                return;
lbl75:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
        }
        while ((currentLine = this.in.readLine()) != null) {
            if (currentLine.indexOf("Content-Length:") == -1) continue;
            dataLength = Integer.parseInt(currentLine.split(" ")[1]);
            break;
        }
        this.in.readLine();
        fileName = this.generateFilename();
        fileout = new DataOutputStream(new FileOutputStream(Configuration.ImageUploadPath + "/" + fileName));
        buf = new byte[1024];
        for (l = dataLength; (bytesRead = this.in.read(buf, 0, Math.min(1024, l))) != -1 && l != 0; l -= bytesRead) {
            fileout.write(buf, 0, bytesRead);
        }
        this.in.readLine();
        currentLine = this.in.readLine();
        if (currentLine == null || currentLine.indexOf("--" + boundary + "--") != -1) {
            // empty if block
        }
        this.log.log(Level.FINER, "successful uploaded map image " + fileName);
        rtnMsg = "http://" + this.ip + ":" + Configuration.ServerPort + "/" + fileName;
        this.sendResponse(200, fileName, false, 1, rtnMsg);
        if (!StringUtils.isNullOrBank(userNo)) {
            try {
                this.modifyUserHead(userNo, fileName);
            }
            catch (Exception er) {
                er.printStackTrace();
            }
        }
        var14_17 = null;
        this.log.log(Level.FINE, "SERVER finished");
        if (fileout == null) return;
        try {}
        catch (IOException e) {
            return;
        }
        fileout.close();
    }

    public void modifyUserHead(String userNo, String head) throws Exception {
        String sql = "select 1 from  k_user_ext where USER_NO=? ";
        ResultSet rs = DaoUtil.queryData((String)sql, (Object[])new Object[]{userNo});
        if (rs.next()) {
            sql = "insert into   arc_k_user_ext (user_no,user_img,up_date,arc_date) select    user_no,user_img,up_date ,now() from  k_user_ext where user_no=? ";
            DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{userNo});
            sql = " update k_user_ext set USER_IMG=?,UP_DATE=now() where user_no=?  ";
            DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{head, userNo});
        } else {
            sql = "insert into k_user_ext(user_no,user_img,up_date) values(?,?,now())";
            DaoUtil.executeUpdate((String)sql, (Object[])new Object[]{userNo, head});
        }
    }

    public void sendResponse(int code) {
        this.sendResponse(code, null, false, 99, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendResponse(int code, String fileName, boolean isFile, int rtnCode, String rtnMsg) {
        String status = "";
        String contentLength = "";
        String contentType = "";
        String responseBody = "";
        FilterInputStream fileReader = null;
        if (code == 200) {
            status = "HTTP/1.1 200 OK\r\n";
        }
        if (code == 404) {
            status = "HTTP/1.1 404 Not Found\r\n";
        }
        responseBody = "\"RTN_FLAG\":\"" + rtnCode + "\"" + ",\"RTN_MSG\":" + "\"" + rtnMsg + "\"";
        if (1 == rtnCode && isFile) {
            try {
                FileInputStream fileInput = new FileInputStream(Configuration.ImageUploadPath + "/" + fileName);
                fileReader = new DataInputStream(fileInput);
                int available = fileInput.available();
                contentLength = "Content-Length: " + available + CRLF;
                contentType = "Content-Type: application/octet-stream\r\n";
            }
            catch (FileNotFoundException e) {
                this.log.log(Level.WARNING, e.getMessage(), e);
            }
            catch (IOException e) {
                this.log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        this.out.write(ImageHandler.toByte(status));
        this.out.write(ImageHandler.toByte(contentType));
        this.out.write(ImageHandler.toByte(contentLength));
        this.out.write(ImageHandler.toByte("Connection: close\r\n"));
        this.out.write(ImageHandler.toByte(CRLF));
        if (isFile) {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = ((DataInputStream)fileReader).read(buffer)) != -1) {
                this.out.write(buffer, 0, bytesRead);
            }
        }
        this.out.write(ImageHandler.toByte(responseBody));
        Object var15_18 = null;
        if (fileReader == null) return;
        try {
            fileReader.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                e.printStackTrace();
                Object var15_19 = null;
                if (fileReader == null) return;
                try {
                    fileReader.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            if (fileReader == null) throw throwable;
            try {
                fileReader.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static byte[] toByte(String s) {
        if (s == null || s.isEmpty()) {
            return new byte[0];
        }
        byte[] r = null;
        try {
            r = s.getBytes("US-ASCII");
        }
        catch (Exception e) {
            r = s.getBytes();
        }
        return r;
    }

    public String generateFilename() {
        byte[] sha1hash = new byte[40];
        Random r = new Random();
        String fileName = "";
        String token = "";
        do {
            token = Long.toString(Math.abs(r.nextLong()), 36) + Long.toString(System.currentTimeMillis());
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                md.update(token.getBytes("iso-8859-1"), 0, token.length());
                sha1hash = md.digest();
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, e.getMessage(), e);
            }
            fileName = ImageHandler.convertToHex(sha1hash);
        } while (new File(Configuration.ImageUploadPath + fileName).exists());
        return fileName;
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buffer.append((char)(48 + halfbyte));
                } else {
                    buffer.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buffer.toString();
    }
}

