/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.net;

import com.aiyc.framework.monitor.Session;
import com.aiyc.framework.monitor.SessionManager;
import com.aiyc.server.standalone.json.GsonFactory;
import com.aiyc.server.standalone.net.HandlerFactory;
import com.aiyc.server.standalone.net.Response;
import com.aiyc.server.standalone.util.Configuration;
import com.aiyc.server.standalone.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class RequestHandler {
    public static final String ACTION_TOKEN = "action";
    public static final String DATA_TOKEN = "data";
    public static final String NO_ACTION = "no action specified";

    public static String getFlowId(JsonElement data) {
        JsonObject headRoot;
        JsonElement head;
        if (data.isJsonObject() && (head = (headRoot = data.getAsJsonObject()).get("HEAD")).isJsonObject()) {
            return head.getAsJsonObject().get("FLOWID").getAsString();
        }
        return null;
    }

    public String request(String request) {
        Response response = new Response(Response.Status.failed, null, null);
        Gson gson = GsonFactory.getGsonInstance();
        JsonParser parser = new JsonParser();
        Object handler = null;
        try {
            JsonElement root = parser.parse(request);
            if (root.isJsonObject()) {
                JsonObject rootobj = root.getAsJsonObject();
                JsonElement action = rootobj.get(ACTION_TOKEN);
                JsonElement data = rootobj.get(DATA_TOKEN);
                if (action == null) {
                    throw new Exception(NO_ACTION);
                }
                String type = (String)gson.fromJson(action, String.class);
                long end = System.currentTimeMillis();
                handler = "anno".equals(Configuration.handerType) ? HandlerFactory.annoHandler(type) : HandlerFactory.findHandler(type);
                String flowId = RequestHandler.getFlowId(data);
                if (flowId != null) {
                    Session ses = null;
                    ses = SessionManager.instance().getSession(flowId);
                    if (ses == null) {
                        ses = new Session();
                        ses.setFlowId(flowId);
                        SessionManager.instance().addSession(ses);
                    } else {
                        ses.reflushTime();
                    }
                }
                response = handler.handle(data);
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            response = new Response(Response.Status.jsonError, e.getMessage(), null);
            Log.getLogger().fine("json parse error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            response = new Response(Response.Status.failed, e.getMessage(), null);
            Log.getLogger().fine("error: " + e.getMessage());
        }
        String response_str = "";
        try {
            response_str = gson.toJson((Object)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            response_str = "{\"status\":\"" + (Object)((Object)Response.Status.jsonError) + "\",\"message\":\"" + e + ": " + e.getMessage() + "\"}";
            Log.getLogger().fine("json serializaion error: " + e.getMessage());
        }
        if (Configuration.LogRequests) {
            try {
                int i = 0;
                while (true) {
                    File f = new File(Configuration.LogRequestPath + "/" + handler.getClass().getSimpleName() + "_" + i);
                    File r = new File(Configuration.LogRequestPath + "/" + handler.getClass().getSimpleName() + "_" + i + "_response");
                    if (!f.exists()) {
                        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                        bw.write(request);
                        bw.close();
                        bw = new BufferedWriter(new FileWriter(r));
                        bw.write(response_str);
                        bw.close();
                        break;
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return response_str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestType {
        setFingerprint,
        getLocation,
        getMapList,
        setMap,
        removeMap,
        getLocationList,
        updateLocation,
        removeLocation,
        currentLocation;

    }
}

