/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.svm;

import com.aiyc.server.standalone.core.Fingerprint;
import com.aiyc.server.standalone.core.Location;
import com.aiyc.server.standalone.core.Measurement;
import com.aiyc.server.standalone.core.measure.WiFiReading;
import com.aiyc.server.standalone.db.HomeFactory;
import com.aiyc.server.standalone.svm.Categorizer;
import java.util.List;

public class CategorizerFactory {
    private static Categorizer pLocationCategorizer;
    private static Categorizer pBSSIDCategorizer;

    public static synchronized Categorizer LocationCategorizer() {
        if (pLocationCategorizer == null) {
            pLocationCategorizer = new Categorizer();
        }
        return pLocationCategorizer;
    }

    public static synchronized Categorizer BSSIDCategorizer() {
        if (pBSSIDCategorizer == null) {
            pBSSIDCategorizer = new Categorizer();
        }
        return pBSSIDCategorizer;
    }

    public static synchronized void buildCategories() {
        List<Fingerprint> dataset = HomeFactory.getFingerprintHome().getAll();
        for (Fingerprint f : dataset) {
            Integer id;
            if (f == null || f.getLocation() == null || f.getMeasurement() == null || (id = ((Location)f.getLocation()).getId()) == null) continue;
            String locationTag = id.toString();
            CategorizerFactory.LocationCategorizer().AddCategory(locationTag);
            Measurement m = (Measurement)f.getMeasurement();
            for (WiFiReading r : m.getWiFiReadings()) {
                if (r == null || r.getBssid() == null) continue;
                CategorizerFactory.BSSIDCategorizer().AddCategory(r.getBssid());
            }
        }
    }
}

