/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.svm;

import com.aiyc.server.standalone.core.Fingerprint;
import com.aiyc.server.standalone.core.Location;
import com.aiyc.server.standalone.core.Measurement;
import com.aiyc.server.standalone.core.measure.WiFiReading;
import com.aiyc.server.standalone.db.HomeFactory;
import com.aiyc.server.standalone.svm.Categorizer;
import com.aiyc.server.standalone.util.ConsoleData;
import java.util.List;

public class MapCategorizerFactory {
    public static synchronized Categorizer LocationCategorizer(String mapId) {
        if (ConsoleData.instance().getCachedValue(mapId) == null) {
            ConsoleData.instance().addCached(mapId, new Categorizer());
        }
        return (Categorizer)ConsoleData.instance().getCachedValue(mapId);
    }

    public static synchronized Categorizer BSSIDCategorizer(String mapId) {
        return MapCategorizerFactory.LocationCategorizer(mapId);
    }

    public static synchronized void buildCategories(String mapId) {
        List<Fingerprint> dataset = HomeFactory.getFingerprintHome().getAll(mapId);
        for (Fingerprint f : dataset) {
            Location id;
            if (f == null || f.getLocation() == null || f.getMeasurement() == null || (id = (Location)f.getLocation()) == null) continue;
            MapCategorizerFactory.LocationCategorizer(mapId).AddCategory(id.getMapXcord() + "" + id.getMapYcord());
            Measurement m = (Measurement)f.getMeasurement();
            for (WiFiReading r : m.getWiFiReadings()) {
                if (r == null || r.getBssid() == null) continue;
                MapCategorizerFactory.BSSIDCategorizer(mapId).AddCategory(r.getBssid());
            }
        }
    }
}

