/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.svm;

import com.aiyc.server.standalone.core.Fingerprint;
import com.aiyc.server.standalone.core.Location;
import com.aiyc.server.standalone.core.Measurement;
import com.aiyc.server.standalone.core.measure.WiFiReading;
import com.aiyc.server.standalone.db.HomeFactory;
import com.aiyc.server.standalone.svm.CategorizerFactory;
import com.aiyc.server.standalone.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.libsvm.core.svm_predict;
import org.libsvm.core.svm_scale;
import org.libsvm.core.svm_train;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVMSupport {
    public static final String TRAIN = "train.1";
    public static final String TEST = "test.1";
    public static final String TEMP = "temp";
    public static final String TRAIN_SCALE = "train.1.scale";
    public static final String TEST_SCALE = "test.1.scale";
    public static final String RANGE = "range1";
    public static final String OUT = "out";
    public static final String MODEL_EXT = ".model";
    public static final String TRAIN_SCRIPT = "train.sh";
    private static int ACTIVE_MODEL = 0;
    private static boolean trained = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void train() {
        Log.getLogger().log(Level.FINE, "Starting SVM train.");
        Log.getLogger().log(Level.FINE, "Building categories...");
        CategorizerFactory.buildCategories();
        List<Measurement> setupdata = HomeFactory.getMeasurementHome().getAll();
        if (setupdata == null || setupdata.size() == 0) {
            return;
        }
        Log.getLogger().log(Level.FINE, "Transforming data to the format of an SVM package...");
        SVMSupport.transformToSVMFormat(setupdata, TRAIN, false);
        Log.getLogger().log(Level.FINE, "Creating the model...");
        int nextModel = Math.abs(ACTIVE_MODEL - 1);
        if (!SVMSupport.runScript(TRAIN_SCRIPT, new String[]{nextModel + ""})) {
            String[] scaleargs = new String[]{"-l", "-1", "-u", "1", "-s", RANGE, TRAIN};
            String[] args = new String[]{"-t", "0", "-c", "512", "-q", TRAIN_SCALE + nextModel, TRAIN_SCALE + nextModel + MODEL_EXT};
            svm_train t = new svm_train();
            svm_scale s = new svm_scale();
            try {
                s.run(scaleargs, TRAIN_SCALE + nextModel);
                t.run(args);
            }
            catch (IOException e) {
                Log.getLogger().log(Level.SEVERE, "Failed to create SVM model: " + e.getMessage());
            }
        }
        Class<SVMSupport> clazz = SVMSupport.class;
        synchronized (SVMSupport.class) {
            ACTIVE_MODEL = nextModel;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Log.getLogger().log(Level.FINE, "SVM train finished..");
            trained = true;
            return;
        }
    }

    public static synchronized String predict(Measurement m) {
        File modelfile = new File(TRAIN_SCALE + ACTIVE_MODEL + MODEL_EXT);
        File outputfile = new File(OUT);
        Vector<Measurement> testMeasurements = new Vector<Measurement>();
        testMeasurements.add(m);
        SVMSupport.transformToSVMFormat(testMeasurements, TEST, true);
        try {
            String[] scaleargs = new String[]{"-r", RANGE, TEST};
            svm_scale s = new svm_scale();
            s.run(scaleargs, TEST_SCALE);
            String[] args = new String[]{TEST_SCALE, modelfile + "", outputfile + ""};
            svm_predict.main(args);
        }
        catch (FileNotFoundException e) {
            Log.getLogger().log(Level.SEVERE, "predict failed due to FileNotFoundException: " + e.getMessage());
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "predict failed due to IOException: " + e.getMessage());
        }
        return OUT;
    }

    public static boolean isTrained() {
        return trained;
    }

    public static synchronized void transformToSVMFormat(List<Measurement> data, String fileName, boolean isNew) {
        File testfile = new File(fileName);
        try {
            BufferedWriter writertest = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(testfile)));
            Hashtable<Integer, Integer> rssis = new Hashtable<Integer, Integer>();
            Vector<Integer> sarray = new Vector<Integer>();
            for (Measurement m : data) {
                Integer categoryID = -1;
                if (!isNew && (categoryID = SVMSupport.getLocationCategory(m)) == -1) continue;
                StringBuffer line = new StringBuffer();
                line.append(categoryID);
                for (WiFiReading r : m.getWiFiReadings()) {
                    Integer id;
                    if (r == null || r.getBssid() == null || (id = CategorizerFactory.BSSIDCategorizer().GetCategoryID(r.getBssid())) == -1 || rssis.contains(id)) continue;
                    rssis.put(id, r.getRssi());
                    sarray.add(id);
                }
                Collections.sort(sarray);
                for (int i = 0; i < sarray.size(); ++i) {
                    if (rssis.get(sarray.get(i)) == null) continue;
                    line.append(" " + sarray.get(i) + ":" + rssis.get(sarray.get(i)));
                }
                line.append("\n");
                writertest.write(line.toString());
                rssis.clear();
                sarray.clear();
            }
            writertest.close();
        }
        catch (FileNotFoundException e) {
            Log.getLogger().log(Level.SEVERE, "transformToSVMFormat failed due to FileNotFoundException: " + e.getMessage());
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "transformToSVMFormat failed due to IOException: " + e.getMessage());
        }
    }

    private static synchronized boolean runScript(String scriptName, String[] args) {
        String command = "./" + scriptName;
        for (String arg : args) {
            command = command + " " + arg;
        }
        try {
            Process p = Runtime.getRuntime().exec(command);
            int exitvalue = p.waitFor();
            if (exitvalue == 0) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Log.getLogger().log(Level.INFO, "runScript failed due to InterruptedException: " + e.getMessage());
        }
        catch (IOException e) {
            Log.getLogger().log(Level.INFO, "runScript failed due to IOException: " + e.getMessage());
        }
        return false;
    }

    private static Integer getLocationCategory(Measurement m) {
        Location l;
        if (m == null || m.getId() == null) {
            return -1;
        }
        Fingerprint f = HomeFactory.getFingerprintHome().getByMeasurementId(m.getId());
        if (f != null && (l = (Location)f.getLocation()) != null && l.getId() != null) {
            return CategorizerFactory.LocationCategorizer().GetCategoryID(l.getId().toString());
        }
        return -1;
    }
}

