/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.svm;

import com.aiyc.server.standalone.svm.MapSVMSupport;
import com.aiyc.server.standalone.util.Configuration;
import com.waspring.wasdbtools.DaoUtil;
import java.sql.ResultSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public final class TrainSVMTimerTask
extends TimerTask {
    public static final long DEFAULT_TRAIN_RATE = 60L;
    private List trainList = new Vector();
    private List runList = new Vector();
    Object lock = new Object();
    Object hulock = new Object();

    public static void start() {
        TrainSVMTimerTask trainSVM = new TrainSVMTimerTask();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)trainSVM, 0L, TrainSVMTimerTask.getTrainRate());
    }

    private static final long getTrainRate() {
        long rate = Configuration.SVMTrainRate;
        if ((double)rate < 1.0) {
            rate = 60L;
        }
        return rate * 1000L * 60L;
    }

    public void run() {
        String sql = "select distinct  mapId from    svmmodel ";
        try {
            ResultSet rs = DaoUtil.queryData((String)sql, (Object[])new Object[0]);
            while (rs.next()) {
                String mapId = rs.getString("mapId");
                this.trainList.add(mapId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Train train = new Train();
        train.start();
        HU hu = new HU();
        hu.start();
    }

    class Train
    extends Thread {
        Train() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object = TrainSVMTimerTask.this.lock;
                        synchronized (object) {
                            if (TrainSVMTimerTask.this.runList.size() == 0) {
                                TrainSVMTimerTask.this.lock.wait();
                            }
                        }
                        object = TrainSVMTimerTask.this.hulock;
                        synchronized (object) {
                            if (TrainSVMTimerTask.this.runList.size() == 0) {
                                TrainSVMTimerTask.this.hulock.notify();
                            }
                        }
                        String mapId = (String)TrainSVMTimerTask.this.runList.remove(0);
                        MapSVMSupport.train(mapId);
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class HU
    extends Thread {
        HU() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (TrainSVMTimerTask.this.trainList.size() > 0) {
                    int len = TrainSVMTimerTask.this.trainList.size() > 10 ? 10 : TrainSVMTimerTask.this.trainList.size();
                    for (int i = 0; i < len; ++i) {
                        TrainSVMTimerTask.this.runList.add(TrainSVMTimerTask.this.trainList.remove(0));
                    }
                    Object object = TrainSVMTimerTask.this.lock;
                    synchronized (object) {
                        if (TrainSVMTimerTask.this.runList.size() > 0) {
                            TrainSVMTimerTask.this.lock.notify();
                        }
                    }
                    object = TrainSVMTimerTask.this.hulock;
                    synchronized (object) {
                        if (TrainSVMTimerTask.this.runList.size() > 0) {
                            TrainSVMTimerTask.this.hulock.wait();
                        }
                    }
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

