/*
 * Decompiled with CFR 0.152.
 */
package com.aiyc.server.standalone.util;

import com.aiyc.server.standalone.util.Log;
import com.waspring.wasdbtools.DatabaseConnection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;

public class Configuration {
    public static final String ANNO = "anno";
    public static final String FILE = "file";
    public static final String ResourcesDir = "/resources/";
    private static final String SQLite_Schema = "/resources/waspring_sqlite.sql";
    public static Integer ServerPort;
    public static Integer LongServerPort;
    public static String ImageUploadPath;
    public static String indoor_location;
    public static LoggerFormat LogFormat;
    public static Level LogLevel;
    public static String LogFile;
    public static String handers;
    public static boolean LogRequests;
    public static String LogRequestPath;
    public static DatabaseTypes DatabaseType;
    public static String DatabaseLocation;
    public static String DatabaseDriver;
    public static String handerType;
    public static String LibSVMDirectory;
    public static long SVMTrainRate;
    public static String get_coupon_url;
    public static String get_deal_url;
    public static String find_businesses_url;
    public static String get_businesses_url;
    public static int max_page;
    public static int search_radais;
    public static String appkey;
    public static String secret;
    public static String hander_indoor_libdir;
    public static String calc_indoor_libdir;
    public static String calc_indoor_path;
    public static int calcSort;
    public static Properties p;

    private static String generateTrainScript(String dir) {
        return "#!/bin/sh \n" + dir + "/svm-scale -l -1 -u 1 -s " + "range1" + " " + "train.1" + " > " + "train.1.scale" + "$1\n" + dir + "/svm-train -c 512 -t 0 -q " + "train.1.scale" + "$1";
    }

    private static void importSQLiteSchema() {
        InputStream is = ClassLoader.class.getResourceAsStream(SQLite_Schema);
        if (is != null) {
            try {
                BufferedReader bf = new BufferedReader(new InputStreamReader(is));
                String sql = "";
                String line = "";
                while ((line = bf.readLine()) != null) {
                    if ((line = line.trim()).endsWith(";")) {
                        sql = sql + line;
                        DatabaseConnection.getInstance();
                        Connection conn = DatabaseConnection.getConnection();
                        Statement stat = conn.createStatement();
                        Log.getLogger().finest("import table " + sql);
                        stat.executeUpdate(sql);
                        sql = "";
                        line = "";
                        continue;
                    }
                    sql = sql + line;
                }
            }
            catch (FileNotFoundException e) {
                Log.getLogger().log(Level.WARNING, "schema file missing: " + e.getMessage(), e);
            }
            catch (SQLException e) {
                Log.getLogger().log(Level.WARNING, "schema file import failed: " + e.getMessage(), e);
            }
            catch (IOException e) {
                Log.getLogger().log(Level.WARNING, "schema file ioerror: " + e.getMessage(), e);
            }
        } else {
            Log.getLogger().log(Level.WARNING, "schema file missing");
        }
    }

    static {
        File dir;
        ServerPort = 1968;
        LongServerPort = 1969;
        ImageUploadPath = "mapuploads/";
        indoor_location = "indoor";
        LogFormat = LoggerFormat.PLAIN;
        LogLevel = Level.WARNING;
        LogFile = "waspring.log";
        handers = "com.waspring.wasservice.net.busii.*";
        LogRequests = false;
        LogRequestPath = "requests/";
        DatabaseType = DatabaseTypes.MYSQL;
        DatabaseLocation = "//localhost:3336/indoor?user=waspring&password=waspring";
        DatabaseDriver = "com.mysql.jdbc.Driver";
        handerType = ANNO;
        LibSVMDirectory = "libsvm-2.9";
        SVMTrainRate = 60L;
        get_coupon_url = "http://api.dianping.com/v1/coupon/get_single_coupon";
        get_deal_url = "http://api.dianping.com/v1/deal/get_single_deal";
        find_businesses_url = "http://api.dianping.com/v1/business/find_businesses";
        get_businesses_url = "http://api.dianping.com/v1/business/get_batch_businesses_by_id";
        max_page = 2000;
        search_radais = 1000;
        hander_indoor_libdir = "wasservice-v0.0.1.jar";
        calc_indoor_libdir = "wasindoor-v0.0.1.jar";
        calc_indoor_path = "com.waspring.wasindoor.locale.IndoorTrainTask";
        calcSort = 1;
        p = new Properties();
        File f = new File("waspring.properties");
        System.out.println("path=" + f.getAbsolutePath());
        if (f.exists()) {
            try {
                File lrp;
                FileInputStream reader = new FileInputStream(f);
                p.load(reader);
                try {
                    ServerPort = new Integer(p.getProperty("port", ServerPort.toString()));
                    LongServerPort = new Integer(p.getProperty("longport", LongServerPort.toString()));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                ImageUploadPath = p.getProperty("image.upload.path", ImageUploadPath);
                if (ImageUploadPath.charAt(ImageUploadPath.length() - 1) == '/') {
                    ImageUploadPath = ImageUploadPath.substring(0, ImageUploadPath.length() - 1);
                }
                LogFile = p.getProperty("log.file", LogFile);
                String format = "";
                try {
                    format = p.getProperty("log.format", LogFormat.name());
                    LogFormat = LoggerFormat.valueOf(format.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    Log.getLogger().log(Level.CONFIG, "No such log format type " + format + ": " + e.getMessage(), e);
                }
                String level = "";
                try {
                    level = p.getProperty("log.level", LogLevel.getName());
                    LogLevel = Level.parse(level);
                }
                catch (IllegalArgumentException e) {
                    Log.getLogger().log(Level.CONFIG, "No such log format type " + format + ": " + e.getMessage(), e);
                }
                LogRequests = Boolean.valueOf(p.getProperty("requests.log", Boolean.valueOf(LogRequests).toString()));
                LogRequestPath = p.getProperty("requests.log.path", LogRequestPath);
                if (LogRequestPath.charAt(LogRequestPath.length() - 1) == '/') {
                    LogRequestPath = LogRequestPath.substring(0, LogRequestPath.length() - 1);
                }
                if (LogRequests && !(lrp = new File(LogRequestPath)).exists()) {
                    lrp.mkdirs();
                }
                String type = "";
                try {
                    type = p.getProperty("db.type", DatabaseType.name());
                    DatabaseType = DatabaseTypes.valueOf(type.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    Log.getLogger().log(Level.CONFIG, "No such database type " + type + ": " + e.getMessage(), e);
                }
                if (DatabaseType == DatabaseTypes.SQLITE) {
                    DatabaseLocation = p.getProperty("db.location", DatabaseLocation);
                    DatabaseDriver = "org.sqlite.JDBC";
                }
                if (DatabaseType == DatabaseTypes.MYSQL) {
                    DatabaseDriver = "com.mysql.jdbc.Driver";
                    DatabaseLocation = p.getProperty("db.location", DatabaseLocation);
                }
                LibSVMDirectory = p.getProperty("svm.libdir", LibSVMDirectory);
                try {
                    SVMTrainRate = Long.parseLong(p.getProperty("svm.trainrate", SVMTrainRate + ""));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                Log.getLogger().log(Level.SEVERE, "Config initialization failed: " + e.getMessage(), e);
                e.printStackTrace();
            }
        }
        if (!(dir = new File(ImageUploadPath)).exists()) {
            if (!dir.mkdirs()) {
                Log.getLogger().log(Level.WARNING, "Image Upload Path could not be created");
            } else {
                Log.getLogger().fine("No image upload dir found, now creating " + ImageUploadPath);
            }
        }
        if (DatabaseType == DatabaseTypes.SQLITE && !new File(DatabaseLocation).exists()) {
            Log.getLogger().fine("No database file found, now importing database schema");
            Configuration.importSQLiteSchema();
        }
        if ((dir = new File(LibSVMDirectory)).isDirectory() && dir.exists()) {
            File trainPl = new File("train.sh");
            try {
                if (!trainPl.exists()) {
                    FileWriter w = new FileWriter(trainPl);
                    w.write(Configuration.generateTrainScript(LibSVMDirectory));
                    ((Writer)w).flush();
                    ((Writer)w).close();
                    trainPl.setExecutable(true);
                }
            }
            catch (Exception e) {
                Log.getLogger().fine("could not create train.sh");
            }
        }
        handers = p.getProperty("hander.pacakges", handers);
        handerType = p.getProperty("hander.type", handerType);
        get_coupon_url = p.getProperty("net.get_coupon_url", get_coupon_url);
        get_deal_url = p.getProperty("net.get_deal_url", get_deal_url);
        calcSort = Integer.parseInt(p.getProperty("calcSort", calcSort + ""));
        find_businesses_url = p.getProperty("net.find_businesses_url", find_businesses_url);
        get_businesses_url = p.getProperty("net.get_businesses_url", get_businesses_url);
        search_radais = Integer.parseInt(p.getProperty("net.search_radais", search_radais + ""));
        appkey = p.getProperty("net.appkey", appkey);
        secret = p.getProperty("net.secret", secret);
        hander_indoor_libdir = p.getProperty("hander.indoor.libdir", hander_indoor_libdir);
        calc_indoor_libdir = p.getProperty("calc.indoor.libdir", calc_indoor_libdir);
        indoor_location = p.getProperty("indoor.location", indoor_location);
        calc_indoor_path = p.getProperty("calc.indoor.path", calc_indoor_path);
        File indoorLocationFile = new File(indoor_location);
        if (!indoorLocationFile.exists()) {
            indoorLocationFile.mkdir();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoggerFormat {
        PLAIN,
        XML;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatabaseTypes {
        SQLITE,
        MYSQL;

    }
}

