/*
 * Decompiled with CFR 0.152.
 */
package com.watchitlater.spring;

import com.watchitlater.spring.BindStatusMap;
import com.watchitlater.spring.MessagesMap;
import com.watchitlater.spring.ThemeMessagesMap;
import com.watchitlater.spring.WebStringTemplate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.util.UrlPathHelper;

public class StringTemplateView
implements View {
    public static final String BASE_PATH = "base";
    public static final String SERVLET_PATH = "servlet";
    public static final String MODEL_KEY = "model";
    public static final String PARAMS_KEY = "params";
    public static final String REQUEST_KEY = "request";
    public static final String SESSION_KEY = "session";
    public static final String APPLICATION_KEY = "application";
    public static final String THEME_MESSAGES_KEY = "themeMessages";
    public static final String BIND_STATUS_KEY = "bindStatus";
    public static final String MESSAGES_KEY = "messages";
    private final UrlPathHelper pathHelper = new UrlPathHelper();
    protected ServletContext servletContext;
    protected boolean exposeRequestContext;
    protected WebStringTemplate template;
    protected String contentType;
    protected boolean autoIndent;

    public void setTemplate(WebStringTemplate template) {
        this.template = template;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setExposeRequestContext(boolean exposeRequestContext) {
        this.exposeRequestContext = exposeRequestContext;
    }

    public void setAutoIndent(boolean autoIndent) {
        this.autoIndent = autoIndent;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModel(model);
        this.exposeRequest(request);
        this.exposeRequestContext(request, response, model);
        response.setContentType(this.getContentType());
        this.template.write(response.getWriter(), this.autoIndent);
    }

    protected void exposeModel(Map<String, ?> model) {
        this.template.setAttribute(MODEL_KEY, model);
        for (Map.Entry<String, ?> entry : model.entrySet()) {
            if (entry.getKey().contains(".")) continue;
            this.template.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    protected void exposeRequest(HttpServletRequest request) {
        this.template.setAttribute(PARAMS_KEY, this.getRequestParameters(request));
        this.template.setAttribute(REQUEST_KEY, this.getRequestAttributes(request));
        this.template.setAttribute(SESSION_KEY, this.getSessionAttributes(request));
        this.template.setAttribute(APPLICATION_KEY, this.getApplicationAttributes());
        String contextPath = this.pathHelper.getContextPath(request);
        String servletPath = this.pathHelper.getServletPath(request);
        this.template.setAttribute(SERVLET_PATH, contextPath + servletPath);
        this.template.setAttribute(BASE_PATH, contextPath);
    }

    protected void exposeRequestContext(HttpServletRequest request, HttpServletResponse response, Map model) {
        if (this.exposeRequestContext) {
            RequestContext requestContext = new RequestContext(request, response, this.servletContext, model);
            this.template.setAttribute(THEME_MESSAGES_KEY, new ThemeMessagesMap(requestContext));
            this.template.setAttribute(BIND_STATUS_KEY, new BindStatusMap(requestContext));
            this.template.setAttribute(MESSAGES_KEY, new MessagesMap(requestContext));
        }
    }

    protected Map<String, Object> getRequestParameters(HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            if (values.length == 1) {
                params.put(name, values[0]);
                continue;
            }
            params.put(name, values);
        }
        return params;
    }

    protected Map<String, Object> getRequestAttributes(HttpServletRequest request) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            attributes.put(name, request.getAttribute(name));
        }
        return attributes;
    }

    protected Map<String, Object> getSessionAttributes(HttpServletRequest request) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        HttpSession session = request.getSession(false);
        if (session != null) {
            Enumeration names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                attributes.put(name, session.getAttribute(name));
            }
        }
        return attributes;
    }

    protected Map<String, Object> getApplicationAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration names = this.servletContext.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            attributes.put(name, this.servletContext.getAttribute(name));
        }
        return attributes;
    }
}

