/*
 * Decompiled with CFR 0.152.
 */
package com.watchitlater.spring;

import com.watchitlater.spring.Renderer;
import com.watchitlater.spring.StringTemplateView;
import com.watchitlater.spring.WebFormat;
import com.watchitlater.spring.WebStringTemplate;
import com.watchitlater.spring.WebStringTemplateGroup;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.Ordered;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ViewResolver;

public class StringTemplateViewResolver
implements ViewResolver,
ResourceLoaderAware,
ServletContextAware,
Ordered {
    protected Map<String, WebStringTemplateGroup> groupCache = new ConcurrentHashMap<String, WebStringTemplateGroup>();
    protected Integer refreshIntervalInSeconds;
    protected boolean useGroupCache = false;
    protected StringTemplateErrorListener templateErrorListener;
    protected ResourceLoader resourceLoader;
    protected String sourceFileCharEncoding;
    protected String templateRoot = "";
    protected String sharedRoot;
    protected List<Renderer> renderers = Collections.emptyList();
    protected WebFormat defaultFormat = WebFormat.html;
    protected ServletContext servletContext;
    protected String contentType = "text/html;charset=UTF-8";
    protected boolean exposeRequestContext = true;
    protected boolean autoIndent = true;
    protected int order = 1;

    public void setUseGroupCache(boolean useGroupCache) {
        this.useGroupCache = useGroupCache;
    }

    public void setTemplateErrorListener(StringTemplateErrorListener templateErrorListener) {
        this.templateErrorListener = templateErrorListener;
    }

    public void setRefreshIntervalInSeconds(Integer refreshIntervalInSeconds) {
        this.refreshIntervalInSeconds = refreshIntervalInSeconds;
    }

    public void setSourceFileCharEncoding(String sourceFileCharEncoding) {
        this.sourceFileCharEncoding = sourceFileCharEncoding;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setTemplateRoot(String templateRoot) {
        this.templateRoot = templateRoot;
    }

    public void setSharedRoot(String sharedRoot) {
        this.sharedRoot = sharedRoot;
    }

    public void setRenderers(List<Renderer> renderers) {
        this.renderers = renderers;
    }

    public void setDefaultFormat(String defaultFormat) {
        this.defaultFormat = WebFormat.fromName(defaultFormat);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setExposeRequestContext(boolean exposeRequestContext) {
        this.exposeRequestContext = exposeRequestContext;
    }

    public void setAutoIndent(boolean autoIndent) {
        this.autoIndent = autoIndent;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public StringTemplateView resolveViewName(String viewName, Locale locale) {
        if (this.shouldNotResolve(viewName)) {
            return null;
        }
        try {
            WebStringTemplate tempate = this.createTemplate(viewName);
            StringTemplateView view = this.createView();
            this.initView(view, tempate);
            return view;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected boolean shouldNotResolve(String viewName) {
        return StringUtils.isBlank((String)viewName) || viewName.startsWith("forward:") || viewName.startsWith("redirect:");
    }

    protected StringTemplateView createView() {
        return new StringTemplateView();
    }

    protected void initView(StringTemplateView view, WebStringTemplate tempate) {
        view.setExposeRequestContext(this.exposeRequestContext);
        view.setServletContext(this.servletContext);
        view.setContentType(this.contentType);
        view.setAutoIndent(this.autoIndent);
        view.setTemplate(tempate);
    }

    protected WebStringTemplate createTemplate(String viewName) {
        WebStringTemplate template = this.createGroup(viewName).createTemplate(viewName);
        template.setDefaultFormat(this.defaultFormat);
        this.registerAttributeRenderers(template);
        return template;
    }

    protected void registerAttributeRenderers(WebStringTemplate template) {
        for (Renderer renderer : this.renderers) {
            template.register(renderer);
        }
    }

    protected WebStringTemplateGroup createGroup(String viewName) {
        return this.useGroupCache ? this.getCachedGroup(viewName) : this.createGroup();
    }

    protected WebStringTemplateGroup getCachedGroup(String viewName) {
        WebStringTemplateGroup group = this.groupCache.get(viewName);
        if (group == null) {
            group = this.createGroup();
            this.groupCache.put(viewName, group);
        }
        return group;
    }

    protected WebStringTemplateGroup createGroup() {
        WebStringTemplateGroup group = this.createGroup("main", this.templateRoot);
        if (this.sharedRoot != null) {
            WebStringTemplateGroup shared = this.createGroup("shared", this.sharedRoot);
            group.setSuperGroup(shared);
        }
        return group;
    }

    protected WebStringTemplateGroup createGroup(String groupName, String groupRoot) {
        WebStringTemplateGroup group = new WebStringTemplateGroup(groupName, groupRoot, this.resourceLoader);
        this.initGroup(group);
        return group;
    }

    protected void initGroup(WebStringTemplateGroup group) {
        if (this.refreshIntervalInSeconds != null) {
            group.setRefreshInterval(this.refreshIntervalInSeconds);
        }
        if (this.sourceFileCharEncoding != null) {
            group.setFileCharEncoding(this.sourceFileCharEncoding);
        }
        if (this.templateErrorListener != null) {
            group.setErrorListener(this.templateErrorListener);
        }
    }
}

