/*
 * Decompiled with CFR 0.152.
 */
package com.watchitlater.spring;

import com.watchitlater.spring.Encoder;
import com.watchitlater.spring.HtmlEncoder;
import com.watchitlater.spring.JavaScriptEncoder;
import com.watchitlater.spring.NoneEncoder;
import com.watchitlater.spring.Utf8UrlEncoder;
import com.watchitlater.spring.WebFormat;
import com.watchitlater.spring.XmlEncoder;
import java.util.HashMap;
import java.util.Map;
import org.antlr.stringtemplate.AttributeRenderer;
import org.apache.commons.lang.ObjectUtils;

public class WebAttributeRenderer
implements AttributeRenderer {
    private WebFormat defaultFormat;
    private Map<WebFormat, Encoder> encoders = new HashMap<WebFormat, Encoder>();

    public WebAttributeRenderer() {
        this.encoders.put(WebFormat.html, new HtmlEncoder());
        this.encoders.put(WebFormat.xml, new XmlEncoder());
        this.encoders.put(WebFormat.js, new JavaScriptEncoder());
        this.encoders.put(WebFormat.url, new Utf8UrlEncoder());
        this.encoders.put(WebFormat.none, new NoneEncoder());
        this.defaultFormat = WebFormat.html;
    }

    public void setDefaultFormat(WebFormat defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    public void setEncoder(WebFormat format, Encoder encoder) {
        this.encoders.put(format, encoder);
    }

    public String toString(Object obj) {
        return this.render(obj, this.defaultFormat);
    }

    public String toString(Object obj, String formatName) {
        return this.render(obj, WebFormat.fromName(formatName));
    }

    private String render(Object obj, WebFormat format) {
        return this.encoders.get((Object)format).encode(ObjectUtils.toString((Object)obj));
    }
}

