/*
 * Decompiled with CFR 0.152.
 */
package com.watchitlater.spring;

import com.watchitlater.spring.WebStringTemplate;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.apache.commons.lang.UnhandledException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class WebStringTemplateGroup
extends StringTemplateGroup {
    protected final ResourceLoader loader;

    public WebStringTemplateGroup(String groupName, String templateRoot, ResourceLoader loader) {
        super(groupName, templateRoot);
        this.loader = loader;
    }

    public WebStringTemplate createTemplate(String templatePath) {
        return (WebStringTemplate)this.getInstanceOf(templatePath);
    }

    public StringTemplate createStringTemplate() {
        return new WebStringTemplate();
    }

    protected StringTemplate loadTemplate(String name, String filePath) {
        Resource resource = this.loader.getResource(filePath);
        if (!resource.exists()) {
            return null;
        }
        InputStream stream = null;
        BufferedReader reader = null;
        try {
            stream = resource.getInputStream();
            reader = new BufferedReader(this.getInputStreamReader(stream));
            StringTemplate stringTemplate = this.loadTemplate(name, reader);
            this.closeQuietly(reader);
            this.closeQuietly(stream);
            return stringTemplate;
        }
        catch (Exception e) {
            try {
                throw new UnhandledException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(reader);
                this.closeQuietly(stream);
                throw throwable;
            }
        }
    }

    protected void closeQuietly(Closeable item) {
        if (item != null) {
            try {
                item.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

