/*
 * Decompiled with CFR 0.152.
 */
package com.watchitlater.spring.sitemesh;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.watchitlater.spring.StringTemplateView;
import com.watchitlater.spring.StringTemplateViewResolver;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.UrlPathHelper;

public class StringTemplateDecoratorServlet
extends HttpServlet {
    protected final UrlPathHelper pathHelper = new UrlPathHelper();
    protected StringTemplateViewResolver resolver;

    public void init(ServletConfig config) throws ServletException {
        this.resolver = this.createResolver(config);
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringTemplateView template = this.resolveTemplate(request);
        if (template != null) {
            this.render(template, request, response);
        } else {
            response.sendError(404);
        }
    }

    protected StringTemplateView resolveTemplate(HttpServletRequest request) {
        return this.resolver.resolveViewName(this.viewName(request), this.getLocale(request));
    }

    protected String viewName(HttpServletRequest request) {
        String lookupPath = this.pathHelper.getLookupPathForRequest(request);
        return StringUtils.substringBeforeLast((String)lookupPath, (String)".st");
    }

    protected Locale getLocale(HttpServletRequest request) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
        if (localeResolver != null) {
            return localeResolver.resolveLocale(request);
        }
        return request.getLocale();
    }

    protected void render(StringTemplateView template, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            template.render(this.pageModel(request), request, response);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, ?> pageModel(HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        HTMLPage page = (HTMLPage)request.getAttribute("__sitemesh__page");
        if (page != null) {
            model.put("page", page);
            model.put("head", StringUtils.trim((String)page.getHead()));
            model.put("body", StringUtils.trim((String)page.getBody()));
            model.put("title", StringUtils.trim((String)page.getTitle()));
        } else {
            model.put("page", new HashMap());
            model.put("title", "No Title");
            model.put("body", "No Body");
            model.put("head", "");
        }
        return model;
    }

    protected StringTemplateViewResolver createResolver(ServletConfig config) {
        StringTemplateViewResolver viewResolver = this.createResolver();
        this.initParameters(viewResolver, config);
        this.initContexts(viewResolver, config);
        return viewResolver;
    }

    protected StringTemplateViewResolver createResolver() {
        return new StringTemplateViewResolver();
    }

    protected void initParameters(StringTemplateViewResolver viewResolver, ServletConfig config) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)viewResolver);
        Enumeration names = config.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!wrapper.isWritableProperty(name)) continue;
            String paramValue = config.getInitParameter(name);
            wrapper.setPropertyValue(name, (Object)paramValue);
        }
    }

    protected void initContexts(StringTemplateViewResolver viewResolver, ServletConfig config) {
        ServletContext ctx = config.getServletContext();
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)ctx);
        StringTemplateErrorListener listener = this.findTemplateErrorListener(wac);
        viewResolver.setTemplateErrorListener(listener);
        viewResolver.setResourceLoader((ResourceLoader)wac);
        viewResolver.setServletContext(ctx);
    }

    protected StringTemplateErrorListener findTemplateErrorListener(WebApplicationContext wac) {
        try {
            return (StringTemplateErrorListener)wac.getBean(StringTemplateErrorListener.class);
        }
        catch (BeansException e) {
            return null;
        }
    }
}

