/*
 * Decompiled with CFR 0.152.
 */
package com.watchrabbit.commons.async;

import com.watchrabbit.commons.exception.SystemException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(FutureContext.class);
    private static final ThreadLocal<FutureContext> threadLocal = new ThreadLocal<FutureContext>(){

        @Override
        protected FutureContext initialValue() {
            return new FutureContext();
        }
    };
    private final Map<Future, Map.Entry<Consumer, Long>> calls = new HashMap<Future, Map.Entry<Consumer, Long>>();

    private FutureContext() {
    }

    public static <T> void register(Future<T> future, Consumer<T> consumer) {
        LOGGER.debug("Registering new future {} and consumer {}", future, consumer);
        FutureContext.getFutureContext().add(future, consumer);
    }

    public static <T> void register(Future<T> future, Consumer<T> consumer, long timeout, TimeUnit timeUnit) {
        LOGGER.debug("Registering new future {} and consumer {} with timeout {} {}", new Object[]{future, consumer, timeout, timeUnit});
        FutureContext.getFutureContext().add(future, consumer, timeout, timeUnit);
    }

    public static void resolve() {
        try {
            FutureContext.getFutureContext().resolveAll();
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOGGER.error("Exception during resolving", (Throwable)ex);
            throw new SystemException("Error thrown during resolve", ex);
        }
    }

    private static FutureContext getFutureContext() {
        return threadLocal.get();
    }

    private <T> void add(Future<T> future, Consumer<T> consumer) {
        this.calls.put(future, new AbstractMap.SimpleEntry<Consumer<T>, Object>(consumer, null));
    }

    private <T> void add(Future<T> future, Consumer<T> consumer, long timeout, TimeUnit timeUnit) {
        this.calls.put(future, new AbstractMap.SimpleEntry<Consumer<T>, Long>(consumer, timeUnit.toMillis(timeout)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveAll() throws InterruptedException, ExecutionException, TimeoutException {
        try {
            for (Future future : this.calls.keySet()) {
                Object result;
                LOGGER.debug("Resolving future {}", (Object)future);
                Map.Entry<Consumer, Long> value = this.calls.get(future);
                if (value.getValue() == null) {
                    LOGGER.debug("Future {} registered without timeout, retrieving the result", (Object)future);
                    result = future.get();
                } else {
                    LOGGER.debug("Future {} registered with timeout, retrieving the result with timeout {} MILISECONDS", (Object)future, (Object)value.getValue());
                    result = future.get(value.getValue(), TimeUnit.MILLISECONDS);
                }
                LOGGER.debug("Invoking consumer of result {}", result);
                value.getKey().accept(result);
            }
        }
        finally {
            LOGGER.debug("Clearing registered calls");
            this.calls.clear();
        }
    }
}

